@extends('layouts.main')
@section('content')
<br>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
    <h2 class="ui horizontal divider cap header" style="color:#dc4900;">
      {{$title}}
    </h2>
    <div class="ui statistics">
      <div class="statistic">
        <div class="value">
          {{$school->schoolStudent->count()}}
        </div>
        <div class="label">
            Students
        </div>
      </div>
      <div class="statistic">
        <div class="value">
          {{$school->schoolTeacher->count()}}
        </div>
        <div class="label">
            Teachers
        </div>
      </div>
      <div class="statistic">
        <div class="value">
          {{$school->schoolAdmin->count()}}
        </div>
        <div class="label">
            Admins
        </div>
      </div>
    </div>
    <br>
    <div class="new">
        @if($school->assessment->count() > 0)
	    <div class="ui cards">
    	@foreach($school->assessment as $assessment)
    		@php
    			$des = '/'.$assessment->path; 
    		@endphp
    		@if(file_exists(public_path($des)))
			<input type="file" onchange="saveMultipleImages(this, '{{$assessment->session}}', '{{$assessment->id}}')" name="path[]" class="file___multipleImagesInput{{$assessment->session}}" style="display: none;" multiple  accept="image/*">
            <div class="card assessment--card--{{$assessment->session}}">
                <div class="content">
                  <img class="right floated mini ui image" src="{{url_public('/images/annual-stats.png')}}">
                  <div class="header">{{$assessment->session}}/{{$assessment->session+1}}</div>
                  <div class="meta">
                    Assessment
                  </div>
                  <div class="description">
                      <a onclick="$(this).parent().find('.images-shell').slideToggle();">View images <i class="image outline icon"></i></a>
                    <div style="display:none" class="images-shell">
                      	@forelse(App\AssessmentImage::where('assessment_id', $assessment->id)->orderBy('id', 'desc')->get() as $image)
                      	<div style="padding:6px !important;">
                          	<img src="{{url_public($image->path)}}" style="width:100%;height:280px;">
                         </div>
                      	@empty
                      	<small style="color: red;">No available image</small>
                      	@endforelse
                    </div>
                  </div>
                </div>
                <div class="extra content">
                  <div class="ui two buttons">
                    <a class="ui basic orange button preview___btn" target="_blank" href="{{url_public('/'.$assessment->path)}}" downlaod>Download Assessment</a>
                    <!--<div class="ui basic blue button edit___btn" data-id="{{$assessment->id}}" data-session="{{$assessment->session}}">Edit</div>-->
                  </div>
                </div>
            </div>
            @endif
        @endforeach
        </div>
        @else
        <div class="ui negative message">
    		<i class="close icon"></i>
    		<div class="header">
    			Opps!
    		</div>
    		<p>
    			No assessment uploaded
    		</p>
    	</div>
    	@endif
    </div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
@endsection