@extends('layouts.main-datatable')
@section('content')
    <section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
        <h1>ODSGMOE Activities Log | {{$title}}</h1>
        <br>
    	@include('super-admin.activity-log.filter')
        <div class="clear">
            @include('pagination.default', ['paginator' => $activities])
        </div>
        <div class="logs">
            @if($activities->count() > 0)
            @foreach($activities as $activity)
            <div class="ui icon message" style="padding: 25px 15px 15px 15px;">
              <i class="
              @if($activity->super_admin_id != 0) user circle @endif
              @if($activity->admin_id != 0) user @endif
              @if($activity->teacher_id != 0) user outline @endif
              @if($activity->student_id != 0) user circle outline @endif
              icon"></i>
              <div class="content">
                <div class="header">
                    @if($activity->superAdmin)
                    <div class="ui inline dropdown">
                        <div class="text">
                          <img class="ui avatar image" src="{{url_public('/images/profile.png')}}">
                          {{$activity->superAdmin->fullname}}
                        </div>
                        <i class="dropdown icon"></i>
                        <div class="menu">
                          <div class="header">
                            Super Administrator
                          </div>
                          <a href="{{route('super_admin.activity-log.super-admin', ['id' => $activity->superAdmin->id])}}" class="item">
                            View all activities
                          </a>
                        </div>
                    </div>
                    @elseif($activity->admin)
                    <div class="ui inline dropdown">
                        <div class="text">
                          <img class="ui avatar image" src="{{url_public($activity->admin->schools->logo)}}">
                          {{$activity->admin->fullname}}
                        </div>
                        <i class="dropdown icon"></i>
                        <div class="menu">
                          <div class="header">
                            School Administrator | {{$activity->admin->schools->name}}
                          </div>
                          <a href="{{route('super_admin.activity-log.admin', ['id' => $activity->admin->id])}}" class="item">
                            View all activities
                          </a>
                        </div>
                    </div>
                    @elseif($activity->teacher)
                    <div class="ui inline dropdown">
                        <div class="text">
                          <img class="ui avatar image" src="{{url_public($activity->teacher->passport)}}">
                          {{$activity->teacher->surname}} {{$activity->teacher->firstname}}
                        </div>
                        <i class="dropdown icon"></i>
                        <div class="menu">
                          <div class="header">
                            School Teacher | {{$activity->teacher->schools->name}}
                          </div>
                          <a href="{{route('super_admin.activity-log.teacher', ['id' => $activity->teacher->id])}}" class="item">
                            View all activities
                          </a>
                        </div>
                    </div>
                    @elseif($activity->student)
                    <div class="ui inline dropdown">
                        <div class="text">
                          <img class="ui avatar image" src="{{url_public($activity->student->passport)}}">
                          {{$activity->student->surname}} {{$activity->student->firstname}}
                        </div>
                        <i class="dropdown icon"></i>
                        <div class="menu">
                          <div class="header">
                            Student | {{$activity->student->schools->name}}
                          </div>
                          <a href="{{route('super_admin.activity-log.student', ['id' => $activity->student->id])}}" class="item">
                            View all activities
                          </a>
                        </div>
                    </div>
                    @endif
                  {{ucfirst($activity->message)}}
                  &nbsp;&nbsp;&nbsp;
                  <small style="font-weight: lighter !important;">{{$activity->created_at->diffForHumans()}}</small>
                </div>
                <p>
                    <div><b>Visited:</b> {{$activity->type}} {{$activity->path}}</div>
                    <div><b>Ip Address:</b> {{$activity->ip}} <a target="_blank" href="https://whatismyipaddress.com/ip/{{$activity->ip}}"><i class="question circle icon"></i></a></div>
                    <div><b>Device:</b> {{$activity->device}}</div>
                </p>
              </div>
            </div>
            @endforeach
            @else
            <div style="color:red;text-align:center;">
                No activity recorded
            </div>
            @endif
        </div>
        <div class="clear">
            @include('pagination.default', ['paginator' => $activities])
        </div>
        <br><br><br>
        <a class="ui labeled blue icon button large">
          <i class="arrow up icon"></i>
          Back To Top
        </a>
    </section>
    <div class="jtr"></div>
@endsection