@extends('student.layouts.main')

@section('content-student')
@include('partial.error')
@php $counter = 0; @endphp
    <h2 class="ui dividing orange header">{{$title}}</h2>
	<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Current School</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School to be Transfer</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Reason For Transfer</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Status</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Actions on Transfer</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($transfers) > 0)
		  	@foreach($transfers as $transfer)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$transfer->formerSchool->name}}</td>
		      <td>{{$transfer->newSchool->name}}</td>
		      <td>{{$transfer->reason_for_transfer}}</td>
		      <td>{!!$transfer->former_school_status == 1 ? '<span style="color: green">Ready to be transfer</span>' : '<span style="color: red">Pending</span>'!!}</td>
		      <td class="std-view">
		      @if($transfer->student_status == 0)
			     <button class="ui labeled blue icon button" data-item="Your Transfer Form" data-href="{{route('student.transfer.update.form')}}">
					  <i class="edit icon"></i>
					  Edit
				</button>
			  @else
			  	<form action="{{route('student.transfer.submission')}}" style="display: inline-block; background-color: #F2711C !important;padding: 10px;border-radius: 5px;" method="post">
			  	{{csrf_field()}}
			  	 <input type="hidden" name="transfer_id" value="{{$transfer->id}}" >
				 <button type="submit" class="ui labeled button" style="color:#ffffff"> View Transfer Form </button>
				</form>
			  @endif


			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>
@endsection