@extends('student.layouts.main')

@section('content-student')
@include('partial.error')
	<form class="ui form" action="{{route('student.transfer.form.submit')}}" method="post">
		<input type="hidden" name="_token" value="{{csrf_token()}}">
		<input type="hidden" name="class_id" value="{{$student_current_class->class_id}}">
		<input type="hidden" name="classarm_id" value="{{$student_current_class->classarm_id}}">
		<input type="hidden" name="term" value="{{$student_current_class->term}}">
		<input type="hidden" name="session" value="{{$student_current_class->session}}">
		@if(isset($transfer))
		<input type="hidden" name="update" value="{{$transfer->id}}">
		@endif
		<div style="max-width: 400px; margin:auto">
		<h2 class="ui dividing header">{{$title}}</h2>
		  <div class="field">
		  	<label>	Current School </label>
		  	<p>{{$student->schools->name}}</p>
		  	<input type="hidden" name="current_school_id" value="{{$student->school_id}}">
		  </div>
	   	 <div class="field">
	        <label>School to be transfered</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="transfer_school_id" @if(!empty(old('transfer_school_id'))) value="{{old('transfer_school_id')}}" @elseif(isset($transfer)) value="{{$transfer->student_new_school}}" @endif>
	          <i class="dropdown icon"></i>
	          <div class="default text">School to be transfered</div>
	          <div class="menu">
	            @forelse($schools as $school)
	             @if( $school->id !== $student->school_id)
	             	<div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
	             @endif
	            @empty
	            @endforelse
	          </div>
	        </div>
	      </div>
	      <div class="field">
		  	<label>	Reason For Transfer </label>
		  	<textarea name="reason_for_transfer" placeholder="Reason For Transfer">@if(!empty(old('reason_for_transfer'))){{old('reason_for_transfer')}}@elseif(isset($transfer)){{$transfer->reason_for_transfer}}@endif</textarea>
		  </div>
		  <div class="field">
			  <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:15px;">Process Transfer School</button>
		  </div>
		 </div>
	</form>
@endsection