@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
    <form class="ui form" action="{{route('student.transfer.submission')}}" method="post">
      <h2 class="ui dividing header">Student Transfer Confirmation</h2>
      <div class="field">
        <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
        <input type="hidden" name="transfer_id" value="{{$student_transfer->id}}">
        <label>Fullnname</label>
        <div class="fields">
          <div class="sixteen wide field">
            <p>{{strtoupper($student->surname.' '.$student->firstname.' '.$student->middlename)}}</p>
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <p>{{\Carbon\Carbon::parse($student->dob)->format('jS F, Y ')}}</p>
          </div>
          <div class="field">
            <label>Gender</label>
            <p>{{$student->gender}}</p>
          </div>
          <div class="field">
            <label>Country</label>
            <p>{{$student->country}}</p>
          </div>
      </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
          <p>{{$student->address}}</p>
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <p>{{$student->state->name}}</p>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <p>{{$student->statelga->name}}</p>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <p>{{$student->religion}}</p>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
            <p>{{$student->phone}}</p>
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
          <p>{{$student->parent_fullname}}</p>
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <p>{{$student->parent_address}}</p>
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
          <p>{{$student->parent_email}}</p>
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <p>{{$student->parent_phone}}</p>
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">School Transfer Information</h4>
        <div class="three fields">
          <div class="field">
            <label>Current School Session</label>
            <p>{{$student_transfer->session}}</p>
          </div>
          

          <div class="field">
            <label>Current School Team</label>
            <p>{{$student_transfer->term}}</p>
            </div>
          

          <div class="field">
            <label>Current School Class</label>
            <p>{{getClassNameByClassID($student_transfer->class_id).' '.getClassArmNameByClassArmID($student_transfer->classarm_id)}}</p>
          </div>
        </div>
      </div>
      <div class="field">
        <h4 class="ui dividing header">School Transfer Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Current School</label>
            <p>{{$student_transfer->formerSchool->name}}</p>
          </div>
          

          <div class="field">
            <label>School to be transfered</label>
            <p>{{$student_transfer->newSchool->name}}</p>
            </div>
          </div>
      </div>
      <div class="field">
          <div class="field">
            <label>Reason For Transfer</label>
            <p>{{$student_transfer->reason_for_transfer}}</p>
          </div>
      </div>

      <div class="field">
      <h4 class="ui dividing header">Transfered Student Passport</h4>
        <div class="fields">
          <div class="four wide field">
           <div class="ui medium image">
            <img src="{{url_public($student->passport)}}">
          </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="two fields">
          <div class="field">
            <a href="{{route('student.transfer.form')}}" class="fluid ui button teal">Change School to be transfered</a>
          </div>
          <div class="field">
            <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Submit Transfer</button>
          </div>
      </div>
      </div>
      
  </form>
</section>
<div class="jtr"></div>
@endsection