@extends('student.layouts.main')
@section('content-student')
@include('partial.error')
<form class="ui form" action="" method="post">
      <h2 class="ui dividing header">Edit Student Registration</h2>
      <div class="field">
        <input type="hidden" name="_method" value="put">
        <input type="hidden" value="{{csrf_token()}}" name="_token">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" @if(!empty(old('surname')))
              value="{{old('surname')}}"
            @else
              value="{{$student->surname}}"
            @endif placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" @if(!empty(old('firstname')))
              value="{{old('firstname')}}"
            @else
              value="{{$student->firstname}}"
            @endif placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" @if(!empty(old('middlename')))
              value="{{old('middlename')}}"
            @else
              value="{{$student->middlename}}"
            @endif placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="three fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob"   @if(!empty(old('dob')))
                value="{{old('dob')}}"
              @else
                value="{{$student->dob}}"
              @endif>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"    @if(!empty(old('gender')))
                  value="{{old('gender')}}"
                @else
                  value="{{$student->gender}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country"     @if(!empty(old('country')))
                  value="{{old('country')}}"
                @else
                  value="{{$student->country}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="eight wide field">
          <label>Contact Address</label>
            <input type="text" name="address"  @if(!empty(old('address')))
                  value="{{old('address')}}"
                @else
                  value="{{$student->address}}"
                @endif placeholder="Contact Address">
          </div>
          <div class="four wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id"     @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$student->state_id}}"
                @endif data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                @foreach($ngstates as $ngstate)
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="four wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id"   @if(!empty(old('lga_id')))
                value="{{old('lga_id')}}"
              @else
                value="{{$student->lga_id}}"
              @endif
              ">
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  @if(!empty(old('state_id')))
                    @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @else
                     @foreach(getStateLGAs($student->state_id) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @endif
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion"   @if(!empty(old('religion')))
                value="{{old('religion')}}"
              @else
                value="{{$student->religion}}"
              @endif
              ">
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone"   @if(!empty(old('phone')))
                value="{{old('phone')}}"
              @else
                value="{{$student->phone}}"
              @endif placeholder="Student's Phone Number">
          </div>
        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Update Student Profile</button>
      
  </form>
@endsection