@extends('layouts.main')

@section('content')
	<section class="ui stackable grid" id="student-dashboard" style="margin-top: 40px; margin-left:20px;">
		<div class="ui floating message four wide column">
			<div class="ui divided items">
			  <div class="item">
			  	<div class="image" style="margin:auto">
			      <img src="{{url_public($student->passport)}}">
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Fullname</div>
			      <div class="description">
			        <p>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</p>
			      </div>
			    </div>
			  </div>
			
			@if($student->afterTransfer()->count() == 0 && $student->beforeTransfer()->count() == 0 )
			  <div class="item">
			    <div class="content">
			      <div class="header">OSSIN</div>
			      <div class="description">
			        <p>{{$student->regnum}}</p>
			      </div>
			    </div>
			  </div>
			@else
				@if($student->beforeTransfer()->count() > 0 )
					@if($student->beforeTransfer()->first()->new_school_status == 1)
						<div class="item">
						    <div class="content">
						      <div class="header">OLD OSSIN</div>
						      <div class="description">
						      	<p>
									{{$student->regnum}}
								</p>
						      </div>
						    </div>
						 </div>
						 <div class="item">
						    <div class="content">
						      <div class="header">NEW OSSIN</div>
						      <div class="description">
						      	<p>
									{{$student->beforeTransfer()->with('studentAfterTransfer')->first()->studentAfterTransfer->regnum}}
								</p>
						      </div>
						    </div>
						 </div>
					@else
						<div class="item">
						    <div class="content">
						      <div class="header">OSSIN</div>
						      <div class="description">
						        <p>{{$student->regnum}}</p>
						      </div>
						    </div>
						</div>
					@endif
				@else
					@if($student->afterTransfer()->first()->new_school_status == 1)
						<div class="item">
						    <div class="content">
						      <div class="header">OLD OSSIN</div>
						      <div class="description">
						      	<p>
									{{$student->afterTransfer()->with('studentBeforeTransfer')->first()->studentBeforeTransfer->regnum}}
								</p>
						      </div>
						    </div>
						</div>
						<div class="item">
						    <div class="content">
						      <div class="header">NEW OSSIN</div>
						      <div class="description">
						      	<p>
									{{$student->regnum}}
								</p>
						      </div>
						    </div>
						</div>
					@else
						<div class="item">
						    <div class="content">
						      <div class="header">OSSIN</div>
						      <div class="description">
						        <p>{{$student->regnum}}</p>
						      </div>
						    </div>
						</div>
					@endif
				@endif
			@endif
			
			  <div class="item">
			    <div class="content">
			      <div class="header">Date of Birth</div>
			      <div class="description">
			        <p>{{ null !== $student->dob ? \Carbon\Carbon::createFromFormat('Y-m-d', $student->dob)->format('jS F, Y ') : 'Date of Birth not Available'}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Gender</div>
			      <div class="description">
			        <p><i class="{{strtolower($student->gender)}} icon"></i>{{$student->gender}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Country</div>
			      <div class="description">
			        <p>{{$student->country}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Contact Address</div>
			      <div class="description">
			        <p>{{$student->address}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">State of Origin</div>
			      <div class="description">
			        <p>{{getStateName($student->state_id)}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">State Local Government Area</div>
			      <div class="description">
			        <p>{{getStateLGAName($student->lga_id)}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Student's Religion</div>
			      <div class="description">
			        <p>{{$student->religion}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Student's Phone Number</div>
			      <div class="description">
			        <p>{{$student->phone}}</p>
			      </div>
			    </div>
			  </div>
			 </div>
		</div>
		<div class="ten wide column">
			@include('partial.error')
			@yield('content-student')
		</div>
	</section>

	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>


	<div class="jtr"></div>
@endsection