@extends('layouts.main-datatable')

@section('content')

<style type="text/css">
.mb30 {
  margin-bottom: 30px;
}
#submitholder {
  margin-top: 30px;
}
.ui.form .field :disabled {
    opacity: 1;
    background: #e2e2e2;
}
table tbody tr td strong {
  color: #060;
}
</style>

@include('partial.error')
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">
    <h2 class="ui orange image header">

      <div class="content">
        Get Student OSSI Number
      </div>
    </h2>
    <form class="ui large form" action="{{route('offlog.student.result.access')}}" method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
      <div class="ui stacked segment">

          <div class="field">
            <label>Surname</label>
            <div class="ui">
                <input type="text" name="surname" id="surname" required="required">
            </div>
          </div>

          <div class="field">
            <label>First Name</label>
            <div class="ui">
                <input type="text" name="firstname" id="firstname" required="required">
            </div>
          </div>

          <div class="field">
            <label>LGA</label>
            <div class="ui">
                <select id="lga_id" name="lga_id" required="required">
                    <option value="">Select LGA</option>
                      @foreach($ondo_lga as $ngstate_lga)
                          <option value="{{$ngstate_lga->id}}">{{$ngstate_lga->name}}</option>
                      @endforeach
                </select>
            </div>
          </div>


          <div id="schoolHolder"></div>

        <div id="submitholder">
            <input type="button" class="ui small blue button" id="form_submit" name="form_submit" value="Get Data" />
        </div>

      </div>

      <div class="ui error message"></div>

    </form>

  </div>
</section>



          <div id="studentDataHolder"></div>

<script>
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";

$(document).ready(function(){

    $('#lga_id').on('change', function(){
        var lga_id = $("#lga_id").val();

        if(lga_id){
          $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
          $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
          $("#pagewrap_ajax_box").show('slow');          
          $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
          window.oncontextmenu = function(){return false;}    // Disable right click  
          $("input").prop('disabled', true);                 // Disable form input
          $("select").prop('disabled', true);                    // Disable form input 

          var route = "{{route('lga.schools')}}";

          $.ajax({
              url: route,
              type: 'POST',
              data: {lga_id: lga_id, _token: token},
              success: function(response){
                  window.oncontextmenu = function(){return true;}     // Enable right click
                  $("#pagewrap_ajax_box").html('');                  
                  $("#pagewrap_ajax_box").hide();                    
                  $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                  $("input").prop('disabled', false);                    // Enable form input            
                  $("select").prop('disabled', false);                   // Enable form input  

                  $('#schoolHolder').html(response);
              },
              error: function(error){
                  window.oncontextmenu = function(){return true;}     // Enable right click
                  $("#pagewrap_ajax_box").html('');                  
                  $("#pagewrap_ajax_box").hide();                    
                  $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                  $("input").prop('disabled', false);                    // Enable form input            
                  $("select").prop('disabled', false);                   // Enable form input  

                  alert('Error encountered while processing request. Pls try again shortly');
              }
          });
        }//end if

    });


$("#form_submit").on('click', function() {

    var lga_id = $("#lga_id").val();
    var firstname = $("#firstname").val();
    var surname = $("#surname").val();
    var school_id = $("#school_id").val();

    if(lga_id && firstname && surname && school_id){

        var form_data = {
            lga_id : lga_id,
            firstname : firstname,
            surname : surname,
            school_id : school_id,
            _token : token
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

          var route = "{{route('offlog.get.student.data')}}";

        $.ajax({
            url :   route,
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            $("#studentDataHolder").html(resp);
            $('#global_datatable').dataTable();
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        });  

    }
    else{
        alert("LGA must be selected to generate statistics")
    }
});


});


</script>

@endsection


