@extends('layouts.main')

@section('content')

<style type="text/css">
.mb30 {
  margin-bottom: 30px;
}
#submitholder {
  margin-top: 30px;
}
.ui.form .field :disabled {
    opacity: 1;
    background: #e2e2e2;
}
</style>

@include('partial.error')
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">
    <h2 class="ui orange image header">

      <div class="content">
        Check Student Result
      </div>
    </h2>
    <form class="ui large form" action="{{route('offlog.student.result.access')}}" method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
      <div class="ui stacked segment">

          <div class="field">
            <label>Student OSSI</label>
            <div class="ui">
                <input type="text" name="regnum" id="regnum" required="required">
            </div>
          </div>

          <div class="field">
            <label>Session</label>
            <div class="ui">
                <select name="session" id="session_val" required="required">
                      <option value="">Select Session</option>
                      <option value=""></option>
                      <?php
                      for($i = 2010; $i <= (date('Y') + 1) ; $i++){
                          $i_n = $i + 1;
                          echo '<option value="'.$i.'">'.$i.'/'.$i_n.'</option>';
                      }
                      ?>
                </select>
            </div>
          </div>

          <div class="field">
            <label>Term</label>
            <div class="ui">
                <select name="term" id="term" required="required">
                    <option value="">Select Term</option>
                      <option value=""></option>
                        <option value="First">First Term</option>
                        <option value="Second">Second Term</option>
                        <option value="Third">Third Term</option>
                </select>
            </div>
          </div>

          <div id="classesHolder"></div>

          <div class="field" id="classarmHolder"></div>

          <div id="scratchCardHolder"></div>

        <div id="submitholder">
            <input type="submit" class="ui fluid large orange submit button" id="form_submit" name="form_submit" value="Process Result" />
        </div>

      </div>

      <div class="ui error message"></div>

    </form>

  </div>
</section>

<script>
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";

(function($){
  alert(99022);
})(jQuery);



$(document).ready(function(){
  alert(11022);
    
    $("#regnum").bind("change keyup", function(){ 
      var regnum = $('#regnum').val();   
      if(regnum && regnum.length >= 10){

          $('#classesHolder').html('');

          $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
          $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
          $("#pagewrap_ajax_box").show('slow');          
          $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
          window.oncontextmenu = function(){return false;}    // Disable right click  
          $("input").prop('disabled', true);                 // Disable form input
          $("select").prop('disabled', true);                    // Disable form input 

          var route = "{{route('regnum.school.classes')}}";

          $.ajax({
              url: route,
              type: 'POST',
              data: {regnum: regnum, _token: token},
              success: function(response){
                  window.oncontextmenu = function(){return true;}     // Enable right click
                  $("#pagewrap_ajax_box").html('');                  
                  $("#pagewrap_ajax_box").hide();                    
                  $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                  $("input").prop('disabled', false);                    // Enable form input            
                  $("select").prop('disabled', false);                   // Enable form input  

                  $('#classesHolder').html(response);
              },
              error: function(error){
                  window.oncontextmenu = function(){return true;}     // Enable right click
                  $("#pagewrap_ajax_box").html('');                  
                  $("#pagewrap_ajax_box").hide();                    
                  $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                  $("input").prop('disabled', false);                    // Enable form input            
                  $("select").prop('disabled', false);                   // Enable form input  

                  alert('Error encountered while processing request. Pls try again shortly');
              }
          });
    
      }
    });


    $('#classesHolder').on('change', '#class_id', function(){
        var class_id = $("#class_id").val();
        var school_id = $("#school_id").val();

        if(school_id){
          $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
          $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
          $("#pagewrap_ajax_box").show('slow');          
          $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
          window.oncontextmenu = function(){return false;}    // Disable right click  
          $("input").prop('disabled', true);                 // Disable form input
          $("select").prop('disabled', true);                    // Disable form input 

          var route = "{{route('school.classarm')}}";

          $.ajax({
              url: route,
              type: 'POST',
              data: {school_id: school_id, class_id: class_id, _token: token},
              success: function(response){
                  window.oncontextmenu = function(){return true;}     // Enable right click
                  $("#pagewrap_ajax_box").html('');                  
                  $("#pagewrap_ajax_box").hide();                    
                  $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                  $("input").prop('disabled', false);                    // Enable form input            
                  $("select").prop('disabled', false);                   // Enable form input  

                  $('#classarmHolder').html(response);
              },
              error: function(error){
                  window.oncontextmenu = function(){return true;}     // Enable right click
                  $("#pagewrap_ajax_box").html('');                  
                  $("#pagewrap_ajax_box").hide();                    
                  $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                  $("input").prop('disabled', false);                    // Enable form input            
                  $("select").prop('disabled', false);                   // Enable form input  

                  alert('Error encountered while processing request. Pls try again shortly');
              }
          });
        }//end if

    });


    $('#classarmHolder').on('change', '#classarm_id', function(){
        var class_id = $("#class_id").val();
        var classarm_id = $("#classarm_id").val();
        var school_id = $("#school_id").val();
        var session_val = $("#session_val").val();
        var term = $("#term").val();
        var regnum = $("#regnum").val();

        verifyStudentScratchCard(class_id, classarm_id, school_id, session_val, term, regnum);

    });

    $('#term').on('change', function(){
        var class_id = $("#class_id").val();
        var classarm_id = $("#classarm_id").val();
        var school_id = $("#school_id").val();
        var session_val = $("#session_val").val();
        var term = $("#term").val();
        var regnum = $("#regnum").val();

        verifyStudentScratchCard(class_id, classarm_id, school_id, session_val, term, regnum);

    });

    $('#session_val').on('change', function(){
        var class_id = $("#class_id").val();
        var classarm_id = $("#classarm_id").val();
        var school_id = $("#school_id").val();
        var session_val = $("#session_val").val();
        var term = $("#term").val();
        var regnum = $("#regnum").val();

        verifyStudentScratchCard(class_id, classarm_id, school_id, session_val, term, regnum);

    });


/*    

    $("#regnum").on('keyup', function(){
      var regnum = $('#regnum').val();   
      if(regnum.length < 6){
          $("#classarmHolder").html('');
          $("#classesHolder").html('');
          $("#scratchCardHolder").html('');
      }
    });

$("#scratchCardHolder").on('keyup', '#card_pin_retype', function(){
      var card_pin_retype = $('#card_pin_retype').val(); 
      var card_pin = $('#card_pin').val();   

      //alert(card_pin_retype+' = '+card_pin);

      if(card_pin_retype.length == 16 && card_pin_retype == card_pin){
          $("#submitholder").show('slow');
      }
      else{
          $("#submitholder").hide();
      }
      
    });*/

});


function verifyStudentScratchCard(class_id, classarm_id, school_id, session_val, term, regnum){
    if(class_id && classarm_id && school_id && session_val && term && regnum){
        $('#scratchCardHolder').html('');

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("#regnum").prop('disabled', true);                 // Disable form input
        $("select").prop('disabled', true);                    // Disable form input 

        var route = "{{route('verify.student.result.scratch.card')}}";

        $.ajax({
            url: route,
            type: 'POST',
            dataType: "json",
            data: {class_id: class_id, classarm_id: classarm_id, school_id: school_id, session_val: session_val, term: term, regnum: regnum, _token: token},
            success: function(response){
                window.oncontextmenu = function(){return true;}     // Enable right click
                $("#pagewrap_ajax_box").html('');                  
                $("#pagewrap_ajax_box").hide();                    
                $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                $("#regnum").prop('disabled', false);                    // Enable form input            
                $("select").prop('disabled', false);                   // Enable form input  

                var htmlFields = '';

                if(response.type === "okay"){                 
                  htmlFields += '<div class="field"><label>Student Name</label><div class="ui"><input type="text" name="student_name" value="'+response.student_name+'" id="student_name" disabled="disabled"></div> <input type="hidden" name="student_id" value="'+response.student_id+'" id="student_id" readonly="readonly"> <input type="hidden" name="request_type" id="request_type" value="1"> </div>';

                  htmlFields += '<div class="field"><label>Card Serial No</label><div class="ui"><input type="text" name="" id="card_serial_mask" value="'+response.serial_no_masked+'" disabled="disabled"></div> <input type="hidden" name="card_serial" value="'+response.serial_no+'" id="card_serial" readonly="readonly"> </div>';

                  htmlFields += '<div class="field"><label>Card Pin</label><div class="ui"><input type="text" name="" id="card_pin_mask" value="'+response.pin_no_masked+'" disabled="disabled"></div> <input type="hidden" name="card_pin" value="'+response.pin_no+'" id="card_pin" readonly="readonly"> </div>';

                  htmlFields += '<div class="field"><label>Retype Card Pin Correctly</label><div class="ui"><input type="text" name="card_pin_retype" id="card_pin_retype"></div> </div>';

                  htmlFields += '<div class="field" style="font-style: italic; font-size: 24px; color: #FF0000; padding: 25px 0 5px 0; border-top:1px solid #f4f4f4;">Forgot OR Lost Your Pin? Enter New One</div>';

                  htmlFields += '<div class="field"><label>New Card Pin</label><div class="ui"><input type="text" name="card_pin_replace_lost" id="card_pin_replace_lost"></div> </div>';

                  htmlFields += '<div class="field"><label>New Card Serial No</label><div class="ui"><input type="text" name="card_serial_replace_lost" id="card_serial_replace_lost"></div> </div>';

                }
                else if(response.type === "null"){
                  htmlFields += '<div class="field"><label>Student Name</label><div class="ui"><input type="text" name="student_name" value="'+response.student_name+'" id="student_name" disabled="disabled"></div> <input type="hidden" name="student_id" value="'+response.student_id+'" id="student_id" readonly="readonly"> <input type="hidden" name="request_type" id="request_type" value="2"> </div>';

                  htmlFields += '<div class="field"><label>Card Pin</label><div class="ui"><input type="text" name="card_pin" id="card_pin"></div></div>';

                  htmlFields += '<div class="field"><label>Card Serial No</label><div class="ui"><input type="text" name="card_serial" id="card_serial"></div></div>';

                }
                else if(response.type === "error"){
                  alert(response.value);
                  htmlFields += '<div class="field mb30"><label>'+response.value+'</label></div>';
                }

                $('#scratchCardHolder').html(htmlFields);
            },
            error: function(error){
                window.oncontextmenu = function(){return true;}     // Enable right click
                $("#pagewrap_ajax_box").html('');                  
                $("#pagewrap_ajax_box").hide();                    
                $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                $("#regnum").prop('disabled', false);                    // Enable form input            
                $("select").prop('disabled', false);                   // Enable form input  

                alert('Error encountered while processing request. Pls try again shortly');
            }
        });

    }//end if
    else{      
        //$("#classarmHolder").html('');
        //$("#classesHolder").html('');
        $("#scratchCardHolder").html('');
    }
}//end function
</script>

@endsection


