<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <title>{{ isset($title) ? $title.' : ' : ''}} Ondo Secondary School App</title>
  
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="csrf_token" content="{{ csrf_token() }}">
  <meta name="author" content="Ondo Secondary School App" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta meta name="viewport" content="width=device-width, user-scalable=no" />
    <!-- <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" /> -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <!-- <meta http-equiv="X-UA-Compatible" content="IE=edge" /> -->
    <meta name="description" content="Welcome to Ondo State Ministry of Education, Science and Technology Website">
    <meta name="keywords" content="ondo state, education, start up design, software, code, tech, computer stuff, store, couture, html, css, javascript, websites, website development, web development, design, ui, ux , agboba gideon , agboba_gideon, agboba kehinde, agboba_kehinde" />
    <meta property="og:locale" content="en-US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ isset($title) ? $title.' : ' : ''}} Ondo Secondary School App" />
    <meta property="og:description" content="Welcome to Ondo State Ministry of Education, Science and Technology Website" />
    <meta property="og:url" content="" />
    <meta property="og:site-name" content="Ondo Secondary School App" />
    <meta property="article:publisher" content="Ondo Secondary School App" />
    <meta property="og:image" content="https://odsgmoe.com/eportal/public/public/images/header-logo.png" />
    <meta property="og:image:secure_url" content="https://odsgmoe.com/eportal/public/public/images/header-logo.png" />
    <meta property="og:image:width" content="312" />
    <meta property="og:image:height" content="313" />
    <meta name="twitter:card" content="summary" />
    <meta name="twitter:title" content="Ondo Secondary School App" />
    <meta name="twitter:site" content="@Ondo_Secondary_School_App" />
    <meta name="twitter:domain" content="Ondo Secondary School App" />
  <link rel="shortcut icon" href="{{url_public('/favicon.ico')}}" type="image/x-icon">
  <link rel="icon" href="{{url_public('/favicon.ico')}}" type="image/x-icon">
    <meta name="msapplication-TileColor" content="#ff7402">
    <meta name="msapplication-TileImage" content="{{url_public('/favicon.ico')}}">
    
    <link href="https://odsgmoe.com/eportal/public/css/overview.css" type="text/css" rel="stylesheet">
    <!--<link href="https://odsgmoe.com/eportal/public/overview/css/materialize.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/css/style.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/css/custom/custom.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/vendors/perfect-scrollbar/perfect-scrollbar.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/vendors/flag-icon/css/flag-icon.min.css" type="text/css" rel="stylesheet">-->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        .hidden_input{
            display: none;
        }
        #loader-wrapper .loader-section{
            background: linear-gradient(to bottom, rgb(255, 154, 0), #FFC107) !important;
            /*background: linear-gradient(45deg, #ff6f00 0%, #ffca28 100%) !important;*/
        }
        .carousel{
            height: 100vh !important;
        }
        .carousel .carousel-item{
            overflow: auto !important;
        }
        .carousel .carousel-item.one{
            padding-left:20px !important;
            padding-right: 20px !important;
            height: 100%;
        }
        .carousel .carousel-item.one img{
            width: auto;
            height: auto;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        .tabs .tab a.active{
            color: #fe7503 !important;
            border-bottom: 1px solid #fe7503;
        }
        i.material-icons.active{
            color: #fe7503 !important;
            border-color: #fe7503 !important;
        }
        label.active{
            color: #fe7503 !important;
            border-color: #fe7503 !important;
        }
        input:focus{
            border-color: #fe7503 !important;
        }
        .input-field .prefix{
            bottom: 19px;
        }
        #toast-container {
          top: auto !important;
          right: auto !important;
          bottom: 5px;
          left: 10px;
        }
        #toast-container .toast{
            border-radius: 24px;
            width: fit-content;
            font-size: small;
        }
        .material-tooltip{
            pointer-events: all !important;
            z-index: 3;
        }
        .backdrop {
            padding: 0px !important;
            margin: 0px;
            height: fit-content !important;
            pointer-events: all !important;
            z-index: 3 !important;
        }
        .quick-auth ul, .quick-auth li{
            text-align: left;
            font-size: 12px;
        }
        .quick-auth .header{
            font-size: 11px;
            color: rgba(0, 0, 0, 0.81);
        }
        .quick-auth .header b{
            color: #000;
        }
        .quick-auth a{
            color: #000;
            margin: 0px;
            text-transform: capitalize;
        }
        .quick-auth i{
            font-size: 12px;
        }
        .indicators{
            z-index: -1;
        }
        .student_name_lable{
            overflow: hidden;
            width: max-content !important;
        }
    </style>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script> 
  <script>
        // window.onbeforeunload = function() {
        //   $('body').removeClass('loaded');
        // };
    </script>
  <script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
  <script data-ad-client="ca-pub-2725963369944173" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
    <script>
      (adsbygoogle = window.adsbygoogle || []).push({
        google_ad_client: "ca-pub-2725963369944173",
        enable_page_level_ads: true
      });
    </script>
    @if(isset($noAutoAd) && $noAutoAd == true)
    @else
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script> <script> (adsbygoogle = window.adsbygoogle || []).push({ google_ad_client: "ca-pub-2725963369944173", enable_page_level_ads: true }); </script>
    @endif
</head>
<body>
    <!-- Start Page Loading -->
    <div id="loader-wrapper">
      <div id="loader"></div>
      <div class="loader-section section-left"></div>
      <div class="loader-section section-right"></div>
    </div>
    
    <!-- START MAIN -->
    <div id="main">
        @if($errors->has())
            <div class="alert-panel card-panel red white-text" style="position: fixed;
            bottom: -15px;
            z-index: 1;
            padding: 20px 10px 0px 10px;
            width:100%;">
              <div class="row valign-wrapper">
                <div class="col s10">
                  <span class="white-text">
                    <ul class="list">
            		@foreach($errors->all() as $error)
            			@if(is_array($error))
            				@foreach($error as $err)
            					<li>{{$err}}</li>
            				@endforeach
            			@else
            				<li>{{$error}}</li>
            			@endif
            		@endforeach
            		</ul>
                  </span>
                </div>
                <div class="col s2">
                  <i class="material-icons">close</i>
                </div>
              </div>
            </div>
        @endif
        @if (Session::has('flash_notification'))
        <div class="alert-panel card-panel grey white-text" style="position: fixed;
        top: -10px;
        z-index: 998;
        padding: 20px 10px 0px 10px;
        width:100%;">
          <div class="row valign-wrapper">
            <div class="col s2">
              <i class="material-icons">close</i>
            </div>
            <div class="col s10">
              <span class="white-text">
                @include('flash::message')
              </span>
            </div>
          </div>
        </div>
        @endif
      <div class="carousel carousel-slider disableDefault">
        <div class="carousel-fixed-item center disableDefault">
        </div>
        <div class="carousel-item one gradient-45deg-amber-amber white-text center disableDefault" href="#one!">
            <div class="carousel-fixed-item center disableDefault">
                @if(Auth::guard('student')->check())
                <a href="{{route('result-app.student.logout')}}" class="logOutBtn btn waves-effect white grey-text darken-text-2">Logout from account</a>
                @else
                <a class="btn waves-effect white grey-text darken-text-2 next">Get Started</a>
                @endif
            </div>
            <h2 style="text-transform:uppercase;margin-bottom: 0px;">Welcome to Ondo <br> State Ministry of Education, Science and Technology Website</h2>
            <p class="white-text" style="margin-top: 5px;">Result checker application</p>
            <img src="https://odsgmoe.com/eportal/public/images/header-logo.png" style="width: 300px;">
        </div>
        @if(Auth::guard('student')->check())
        @else
        <div class="carousel-item three white black-text disableDefault" href="#four!">
            <ul id="tabs-swipe-demo" class="tabs" style="zoom:80%;">
                <li class="tab col s3"><a class="active black-text" href="#test-swipe-4">Student Login</a></li>
            </ul>
            <div id="test-swipe-4" class="col view s12" style="padding: 20px;">
                <form action="{{route('result-app.student.login.submit')}}" method="post">
                    <input type="hidden" name="_token" value="{{csrf_token()}}">
                  <div class="row">
                    <div class="input-field col s12">
                      <i class="material-icons prefix">assignment_ind</i>
                      <input id="icon_prefix" type="number" class="key" name="regnum" value="{{old('regnum')}}" required>
                      <label for="icon_prefix">Registration Number</label>
                    </div>
                    <div class="input-field col s12">
                      <i class="material-icons prefix">lock</i>
                      <input id="icon_password" name="password" type="password" class="password" required>
                      <label for="icon_password">Password</label>
                    </div>
                    <div class="input-field col s12">
                        <button class="btn black waves-effect waves-light btn-fluid" type="submit">Login</button>
                    </div>
                  </div>
                </form>
            </div>
            <div style="padding: 10px 30px 20px 30px">
                <button class="btn black waves-effect waves-light btn-fluid next" type="button">View Student Result With OSSI Number</button>
            </div>
            <br>
            <div style="text-align:center;">
                Need help? <a id="help_href" href="{{route('result-app.help')}}">click here for assistance</a>
            </div>
            <br>
            <div style="padding: 20px;">
                <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                <!-- Overview Login -->
                <ins class="adsbygoogle"
                     style="display:block"
                     data-ad-client="ca-pub-7258522889310876"
                     data-ad-slot="8493433426"
                     data-ad-format="auto"
                     data-full-width-responsive="true"></ins>
                <script>
                     (adsbygoogle = window.adsbygoogle || []).push({});
                </script>
            </div>
        </div>
        @endif
        <div class="carousel-item three white black-text disableDefault" href="#five!">
            <ul id="tabs-swipe-demo-two" class="tabs" style="zoom:80%;">
                <li class="tab col s3"><a class="active black-text" href="#test-swipe-5">Result Checker with OSSI Number</a></li>
            </ul>
            <div id="test-swipe-5" class="col view s12" style="padding: 20px;">
                <form action="{{route('result-app.result-check')}}" method="post" onsubmit="event.preventDefault(); downlaodResult(this);">
                    <input type="hidden" name="_token" value="{{csrf_token()}}">
                    <input type="hidden" name="request_type" value="2">
                  <div class="row">
                    <div class="input-field col s7">
                      <input id="regnum__input" type="number" class="key" name="regnum" value="{{old('regnum')}}" data-url="{{route('result-app.api.get-classes')}}" required>
                      <label class="student_name_lable">OSSI Number</label>
                    </div>
                    <div class="input-field col s5">
                        <button onclick="getClasses(this, '#regnum__input')" class="btn black" type="button">Search</button>
                    </div>
                    <div class="input-field col s12 hidden_input">
                        <select type="text" name="session" required>
                            <option value="" selected disabled>Select Session</option>
                            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                            <option value="{{$i}}">{{$i}}/{{$i+1}}</option>
                            @endfor
                        </select>
                        <label>Session Select</label>
                    </div>
                    <div class="input-field col s12 hidden_input">
                        <select type="text" name="term" required>
                            <option value="" selected disabled>Select Term</option>
                            <option value="First">First Term</option>
                            <option value="Second">Second Term</option>
                            <option value="Third">Third Term</option>
                        </select>
                        <label>Term Select</label>
                    </div>
                    <div class="input-field col s12 hidden_input">
                        <select type="text" id="classes_select" name="class_id" onchange="getClassArms(this)" data-url="{{route('result-app.api.get-class-arms')}}" required>
                            <option value="" disabled>Select Class</option>
                        </select>
                        <label>Class Select</label>
                    </div>
                    <div class="input-field col s12 hidden_input">
                        <select type="text" id="class_arm_select" name="classarm_id" required>
                            <option value="" disabled>Select Class Arm</option>
                        </select>
                        <label>Class Arm  Select</label>
                    </div>
                    <div class="input-field col s12 hidden_input">
                      <input type="number" name="card_pin" value="{{old('card_pin')}}" required>
                      <label>Card Pin</label>
                    </div>
                    <div class="input-field col s6">
                        <button style="float:left;" class="btn grey waves-effect waves-light btn-fluid prev" type="button">Back</button>
                    </div>
                    <div class="input-field col s6 hidden_input">
                        <button style="float:right;" class="btn black waves-effect waves-light btn-fluid" type="submit">Download Result</button>
                    </div>
                  </div>
                </form>
                <a id="downlaodTrigger" target="_blank" href="https://odsgmoe.com/eportal/public/images/header-logo.png"></a>
            </div>
            <br>
            <div style="text-align:center;">
                Need help? <a id="help_href" href="{{route('result-app.help')}}">click here for assistance</a>
            </div>
            <br>
            <div style="padding: 20px;">
                <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                <!-- Overview Login -->
                <ins class="adsbygoogle"
                     style="display:block"
                     data-ad-client="ca-pub-7258522889310876"
                     data-ad-slot="8493433426"
                     data-ad-format="auto"
                     data-full-width-responsive="true"></ins>
                <script>
                     (adsbygoogle = window.adsbygoogle || []).push({});
                </script>
            </div>
        </div>
      </div>
    </div>
    <!-- END MAIN -->
        
    <!--QUICK AUTHS-->
    @include('result-app.layouts.quick-auth')
    <!--END QUICK AUTHS-->
    
    <script type="text/javascript" src="https://odsgmoe.com/eportal/public/js/overview-main.js"></script>
    <script type="text/javascript" src="https://odsgmoe.com/eportal/public/js/overview.js"></script>
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/vendors/jquery-3.2.1.min.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/js/materialize.min.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/vendors/perfect-scrollbar/perfect-scrollbar.min.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/js/plugins.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/js/custom-script.js"></script>-->
    <script>
        $(function(){
            $('.dropdown-trigger').dropdown();
            
            $('.tooltipped').tooltip({html: true});
            
            $('.carousel.carousel-slider').carousel({
                fullWidth: true,
                indicators: true
            });
            
            // $('.dropdown-trigger').each(function(){
            //     $(this).on('click touchstart', e => {
            //         e.preventDefault();
            //         var divClass = $(this).attr('data-target');
            //         $('#'+divClass).dropdown('open');
            //         console.log('aczv');
            //     });
            // });
            
            $('.tabs .tab').each(function(){
                $(this).on('click touchstart', e => {
                    e.preventDefault();
                });
            });
            
            $('.fixed-action-btn.active').click(function(){
                $(this).removeClass('active');
            });
            
            $('#help_href').on('click touchstart', e => {
                $('body').removeClass('loaded');
                e.preventDefault();
                e.stopPropagation();
                window.location = $('#help_href').attr('href');
            });
            
            $('.btn.next').each(function(){
                $(this).on('click touchstart', e => {
                    e.preventDefault();
                    e.stopPropagation();
                    $('.carousel.carousel-slider').carousel('next');
                    console.log('next');
                });
            });
            
            $('.btn.prev').each(function(){
                $(this).on('click touchstart', e => {
                    e.preventDefault();
                    e.stopPropagation();
                    $('.carousel.carousel-slider').carousel('prev');
                    console.log('prev');
                });
            });
            
            $('.btn.logOutBtn').each(function(){
                $(this).on('click touchstart', e => {
                    e.preventDefault();
                    e.stopPropagation();
                    window.location = $(this).attr('href');
                });
            });
            
            $('form').each(function(){
                $(this).find('input').each(function(){
                    $(this).on('click touchstart', e => {
                        $(this).focus();
                    });
                });
            });
            
            $('button[type=submit]').each(function(){
                $(this).on('click touchstart', e => {
                    var oldHtml = $(this).html();
                    $(this).html('...');
                    $(this).css('pointer-events', 'none');
                    $(this).css('opacity', '0.7');
                    if($(this).parents('form').first().find('input.key').val() == '' || $(this).parents('form').first().find('input.password').val() == ''){
                        Materialize.toast('Please fill up all fields', 6000);
                        $(this).html(oldHtml);
                        $(this).css('pointer-events', 'all');
                        $(this).css('opacity', '1');
                    }else{
                        $(this).parents('form').first().submit();
                        setTimeout(function(){
                            $(this).html(oldHtml);
                            $(this).css('pointer-events', 'all');
                            $(this).css('opacity', '1');
                        }, 3000);
                    }
                });
            });
            $('.alert-panel').each(function(){
                var alert = $(this);
                alert.find('i').on('click touchstart', e => {
                    alert.remove();
                });
            });
            
            
            $('select').trigger('contentChanged');
            $('select').material_select();
        });
        
        jQuery.Event.prototype.preventDefault = (function(){
            var originalFunc = jQuery.Event.prototype.preventDefault;
            return function(){
                if($(this.target).hasClass('disableDefault')) {return;}
                originalFunc.call(this);
            }
        }())
        
        function getClasses(obj, objId){
            var btn, select, value, url, data, token, option;
            btn = $(obj);
            select = $(objId);
            value = select.val();
            token = $('input[name=_token]').first().val();
            data = {regnum: value, _token: token};
            url = select.attr('data-url');
            btn.html('...');
            btn.attr('disabled', 'disabled');
            $('#classes_select').parents('.select-wrapper').first().addClass('disabled');
            $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'none');
            // throw ajax
            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                success: function(res){
                    option = `<option value="" disabled selected >Select Class</option>`;
                    $.each(res.data, function(index, value){
                        option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
                    });
                    $('.student_name_lable').html(res.name.toUpperCase());
                    $('.hidden_input').slideDown('fast');
                    $('#classes_select').removeClass('initialized');
                    $('#classes_select').html(option);
                    $('#classes_select').trigger('contentChanged');
                    $('#classes_select').material_select();
                    $('#classes_select').parents('.select-wrapper').first().removeClass('disabled');
                    $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'all');
                    btn.html('Search');
                    btn.removeAttr('disabled');
                },
                error: function(err){
                    btn.html('Search');
                    btn.removeAttr('disabled');
                    $('.student_name_lable').html('OSSI Number');
                    $('.hidden_input').slideUp('fast');
                    Materialize.toast(err.responseJSON.message, 6000);
                }
            });
        }
        
        function getClassArms(obj){
            var select, value, url, data, token, option;
            select = $(obj);
            value = select.val();
            token = $('input[name=_token]').first().val();
            data = {class_id: value, _token: token};
            url = select.attr('data-url');
            $('#class_arm_select').parents('.select-wrapper').first().addClass('disabled');
            $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'none');
            // throw ajax
            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                success: function(res){
                    option = `<option value="" disabled selected >Select Class Arm</option>`;
                    $.each(res.data, function(index, value){
                        option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
                    });
                    console.log(option);
                    $('#class_arm_select').removeClass('initialized');
                    $('#class_arm_select').html(option);
                    $('#class_arm_select').trigger('contentChanged');
                    $('#class_arm_select').material_select();
                    $('#class_arm_select').parents('.select-wrapper').first().removeClass('disabled');
                    $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'all');
                },
                error: function(err){
                    Materialize.toast('Failed to fetch class arms', 6000);
                }
            });
        }
        
        function downlaodResult(obj){
            var form, url, data, btn, oldHtml, blob, link, message;
            form = $(obj);
            data = form.serialize();
            url = form.attr('action');
            btn = form.find('button[type=submit]');
            oldHtml = 'Download Result';
            
            btn.html('...'); 
            btn.css('pointer-events', 'none');
            btn.css('opacity', '0.7');
            $('#downlaodTrigger').html('');
            // throw ajax
            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                cache: false,
                success: function (response, ) {
                    btn.html(oldHtml);
                    btn.css('pointer-events', 'all');
                    btn.css('opacity', '1');
                    $('#downlaodTrigger').attr('href', 'https://odsgmoe.com/eportal/pdf-download-result?blob='+response+'&student='+$('#regnum__input').val());
                    window.open('https://odsgmoe.com/eportal/pdf-download-result?blob='+response+'&student='+$('#regnum__input').val(), '_system');
                    $('#downlaodTrigger').html(`Download did'nt start? Click to here to download ${$('#regnum__input').val()}'s Result`);
                    $('#downlaodTrigger')[0].trigger('click');
                },
                error: function(err){
                    btn.html(oldHtml);
                    btn.css('pointer-events', 'all');
                    btn.css('opacity', '1');
                    if(err.responseJSON.message != undefined || err.responseJSON.message != null || err.responseJSON.message != ''){
                        message = err.responseJSON.message;
                    }else{
                        message = '';
                    }
                    Materialize.toast('Failed to fetch result record'+message, 6000);
                }
            });
        }
    </script>
</body>
</html>