@extends('result-app.layouts.main')
@section('content')
<div>
    <form action="{{route('result-app.result-check')}}" method="post" onsubmit="downlaodResult(this);">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <input type="hidden" name="request_type" value="2">
        <input type="hidden" name="regnum" value="{{$student->regnum}}">
        <input type="hidden" name="card_pin" value="{{$pin}}">
        <input type="hidden" name="session" value="{{$session}}">
      <div class="row">
        <div class="input-field col s12">
          <input id="regnum__input" type="number" disabled value="{{$student->regnum}}" required>
          <label class="student_name_lable" style="text-transform: uppercase;">{{$student->surname}} {{$student->firstname}} {{$student->middlename}}</label>
        </div>
        <div class="input-field col s12">
            <select type="text" disabled required>
                <option selected>{{$session}}/{{$session + 1}}</option>
            </select>
            <label>Session Select</label>
        </div>
        <div class="input-field col s12">
            <select type="text" name="term" required>
                <option value="" selected disabled>Select Term</option>
                <option value="First">First Term</option>
                <option value="Second">Second Term</option>
                <option value="Third">Third Term</option>
            </select>
            <label>Term Select</label>
        </div>
        <div class="input-field col s12">
            <select type="text" id="classes_select" name="class_id" onchange="getClassArms(this)" data-url="{{route('result-app.api.get-class-arms')}}" required>
                <option value="" selected disabled>Select Class</option>
                @foreach(getClasses($student->school_id) as $class)
                <option value="{{$class->id}}">{{$class->class_name}}</option>
                @endforeach
            </select>
            <label>Class Select</label>
        </div>
        <div class="input-field col s12">
            <select type="text" id="class_arm_select" name="classarm_id" required>
                <option value="" selected disabled>Select Class Arm</option>
            </select>
            <label>Class Arm  Select</label>
        </div>
        <div class="input-field col s12">
          <input type="number" disabled value="{{$pin}}" required>
          <label>Card Pin</label>
        </div>
        <div class="input-field col s12">
            <button class="btn black waves-effect waves-light btn-fluid" type="submit">Download Result</button>
        </div>
      </div>
    </form>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function(){
    $('.tooltipped').tooltip();
});

function downlaodResult(obj){
    var form, url, data, btn, oldHtml, blob, link;
    form = $(obj);
    data = form.serialize();
    url = form.attr('action');
    btn = form.find('button[type=submit]');
    oldHtml = btn.html();
    
    btn.html('...'); 
    btn.css('pointer-events', 'none');
    btn.css('opacity', '0.7');
    
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        cache: false,
        success: function(res){
            btn.html(oldHtml);
            btn.css('pointer-events', 'all');
            btn.css('opacity', '1');
            $('body').toggleClass('loaded');
        },
        error: function(err){
            btn.html(oldHtml);
            btn.css('pointer-events', 'all');
            btn.css('opacity', '1');
            $('body').toggleClass('loaded');
            Materialize.toast('Failed to fetch result record', 6000);
        }
    });
}

function getClasses(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {school_id: value, _token: token};
    url = select.attr('data-url');
    $('#classes_select').parents('.select-wrapper').first().addClass('disabled');
    $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#classes_select').removeClass('initialized');
            $('#classes_select').html(option);
            $('#classes_select').trigger('contentChanged');
            $('#classes_select').material_select();
            $('#classes_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch classes', 6000);
        }
    });
}

function getClassArms(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {class_id: value, _token: token};
    url = select.attr('data-url');
    $('#class_arm_select').parents('.select-wrapper').first().addClass('disabled');
    $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class Arm</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#class_arm_select').removeClass('initialized');
            $('#class_arm_select').html(option);
            $('#class_arm_select').trigger('contentChanged');
            $('#class_arm_select').material_select();
            $('#class_arm_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch class arms', 6000);
        }
    });
}
</script>
@endsection