@extends('result-app.layouts.main')
@section('content')
<div id="card-widgets">
    <div class="row">
        <div class="col s12 m12 l4">
            <div class="input-field col s12">
                <select type="text" onchange="window.location = $(this).attr('data-url')+'/'+$(this).val();" data-url="{{url('/result-app/student/digital-card')}}" name="session" required>
                    <option value="" disabled @if($session == 0) selected @endif>Select Session</option>
                    @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                    <option @if($session == $i) selected @endif value="{{$i}}">{{$i}}/{{$i+1}}</option>
                    @endfor
                </select>
                <label>Session Select</label>
            </div>
        </div>
    </div>
</div>
<div id="work-collections">
    <div class="row">
        <div class="col s12 m4 l4">
          <ul id="projects-collection" class="collection z-depth-1">
            <li class="collection-item avatar">
              <i class="material-icons cyan circle">credit_card</i>
              <h6 class="collection-header m-0">{{ucwords($title)}}</h6>
              <p>Full digital payment record for {{$session}}</p>
            </li>
            @if($digitalRecord)
            @php
                $student_vouchers = App\ResultVoucher::where('student_id', $student->id)
                                ->where('session', $session)
                                ->get();
            @endphp
            <li class="collection-item modal-activator" data-modal="#cardModal{{$session}}">
              <div class="row">
                <div class="col s12">
                  <p class="collections-title">{{strtoupper($student->firstname)}} {{strtoupper($student->lastname)}} {{strtoupper($student->middlename)}}</p>
                  <p class="collections-content">Amount ₦{{DB::table('payment_items')->first()->cost + 200}}</p>
                  <small class="grey-text">Reciept was generated {{$digitalRecord->created_at->diffForHumans()}}</small>
                </div>
              </div>
            </li>
            <!-- Modal --> 
            <div id="cardModal{{$session}}" class="modal bottom-sheet">
                <div class="modal-content">
                  <div class="row">
                    <div class="col s12">
                        <span class="black-text">
                            <h5>Scratch Cards</h5>
                            @forelse($student_vouchers as $student_voucher)
                            <span class="grey-text">Pin:</span> <span class="text-transform: capitalize;">{{$student_voucher->pin}}</span><br>
                            <span class="grey-text">Serial:</span> <span class="text-transform: capitalize;">{{$student_voucher->serial}}</span><br><br>
                            <a href="{{route('result-app.student.results')}}/{{$student_voucher->pin}}/{{$session}}" class="btn black">View {{$session}}'s Results</a><br>
                            <br>
                            @empty
                            <span class="red-text">No scratch card generated. Contact school administrator</span><br>
                            @endforelse
                        </span>
                    </div>
                  </div>
                </div>
            </div>
            @else
            <div style="color:red;text-align:center;padding:20px;">
                <small>
                    No payment made for this session
                </small>
            </div>
            @endif
          </ul>
        </div>
    </div>
</div>
@endsection