@extends('result-app.layouts.main')
@section('content')
<div id="card-widgets">
    <div class="row">
        <div class="col s12 m12 l4">
            <form class="formOne" action="" method="POST">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
                <button type="submit" style="display: none;"></button>
                <div id="flight-card" class="card">
                    <div class="card-header deep-orange accent-2">
                      <div class="card-title">
                        <h4 class="flight-card-title">Search Record</h4>
                        <p class="flight-card-date">Search student's attendance records</p>
                      </div>
                    </div>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="date" required>
                      <option value="" disabled @if($date == '') selected @endif>Select Date</option>
                      <option @if($date == 'today') selected @endif value="today">Today</option>
                      <option @if($date == 'yesterday') selected @endif value="yesterday">Yesterday</option>
                      <option @if($date == 'this_week') selected @endif value="this_week">This Week</option>
                      <option @if($date == 'this_month') selected @endif value="this_month">This Month</option>
                      <option @if($date == 'all') selected @endif value="all">All</option>
                    </select>
                    <label>Date Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="session" required>
                        <option value="" disabled @if($session == 0) selected @endif>Select Session</option>
                        @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                        <option @if($session == $i) selected @endif value="{{$i}}">{{$i}}/{{$i+1}}</option>
                        @endfor
                    </select>
                    <label>Session Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="term" required>
                        <option value="" disabled @if($term == '') selected @endif>Select Term</option>
                        <option @if($term == 'First') selected @endif value="First">First Term</option>
                        <option @if($term == 'Second') selected @endif value="Second">Second Term</option>
                        <option @if($term == 'Third') selected @endif value="First">Third Term</option>
                    </select>
                    <label>Term Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" id="classes_select" name="class_id"  onchange="getClassArms(this)" data-url="{{route('overview-app.api.get-class-arms')}}" required>
                        <option value="" disabled @if($class_id == 0) selected @endif>Select Class</option>
                        @if($school_id != 0)
                        @foreach(getClasses($school_id) as $class)
                        <option @if($class_id == $class->id) selected @endif value="{{$class->id}}">{{$class->class_name}}</option>
                        @endforeach
                        @endif
                    </select>
                    <label>Class Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="subject_id" required>
                      <option value="" disabled @if($subject_id == '') selected @endif>Select Subject</option>
                      <option @if($subject_id == 0) selected @endif value="0">None</option>
                      @foreach(App\Subject::all() as $subject)
                        <option @if($subject_id == $subject->id) selected @endif value="{{$subject->id}}">{{$subject->class_category}} - {{strtoupper($subject->subject_name)}} [{{$subject->subject_code}}]</option>
                      @endforeach
                    </select>
                    <label>Subject Select</label>
                </div>
                <div class="input-field col s12">
                    <button class="btn waves-effect waves-light deep-orange accent-2" onclick="$('form.formOne button[type=submit]').trigger('click');">Search</button>
                </div>
            </form>
        </div>
    </div>
</div>
<br>
<div id="work-collections">
    <div class="row">
        <div class="col s12 m4 l4">
          <ul id="projects-collection" class="collection z-depth-1">
            <li class="collection-item avatar">
              <i class="material-icons cyan circle">assignment</i>
              <h6 class="collection-header m-0">{{ucfirst($student->firstname)}}'s Attendance</h6>
              <p>Total attendance: {{$attendance_count}}</p>
            </li>
            @if($attendance_count > 0)
            @foreach($attendance as $log)
            @php error_reporting(0); @endphp
            @if($subject_id == 0)
            <!--class attendance-->
            @php $student = $log->student; $teacher = $log->teacher; @endphp
            <li class="collection-item">
              <div class="row">
                <div class="col s12">
                  <p class="collections-title">{{strtoupper(getClassNameByClassID($student->classarms[0]->pivot->class_id))}} {{strtoupper(getClassArmNameByClassArmID($student->classarms[0]->pivot->classarm_id))}}</p>
                  <p class="collections-content">Marked by {{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</p>
                  <small class="grey-text">{{$log->created_at->diffForHumans()}}</small>
                </div>
              </div>
            </li>
            @else
            <!--subject attendance-->
            @php $subject = $log->subject; $teacher = $log->teacher; @endphp
            <li class="collection-item">
              <div class="row">
                <div class="col s12">
                  <p class="collections-title">{{strtoupper($subject->subject_name)}} [{{$subject->subject_code}}]</p>
                  <p class="collections-content">Marked by {{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</p>
                  <small class="grey-text">{{$log->created_at->diffForHumans()}}</small>
                </div>
              </div>
            </li>
            @endif
            @endforeach
            @else
            <div style="color:red;text-align:center;padding:20px;">
                <small>
                    No available record
                </small>
            </div>
            @endif
          </ul>
            @include('result-app.pagination.default', ['paginator' => $attendance])
        </div>
      </div>
</div>
<script>
$(document).ready(function(){
    $('.tooltipped').tooltip();
});

function getClasses(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {school_id: value, _token: token};
    url = select.attr('data-url');
    $('#classes_select').parents('.select-wrapper').first().addClass('disabled');
    $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#classes_select').removeClass('initialized');
            $('#classes_select').html(option);
            $('#classes_select').trigger('contentChanged');
            $('#classes_select').material_select();
            $('#classes_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch classes', 6000);
        }
    });
}

function getClassArms(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {class_id: value, _token: token};
    url = select.attr('data-url');
    $('#class_arm_select').parents('.select-wrapper').first().addClass('disabled');
    $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class Arm</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#class_arm_select').removeClass('initialized');
            $('#class_arm_select').html(option);
            $('#class_arm_select').trigger('contentChanged');
            $('#class_arm_select').material_select();
            $('#class_arm_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch class arms', 6000);
        }
    });
}
</script>
@endsection