<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>{{ isset($title) ? $title.' : ' : ''}} Ondo Secondary School App</title>
	
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="csrf_token" content="{{ csrf_token() }}">
	<meta name="author" content="Ondo Secondary School App" />
    
    <!--caching meta-->
    <meta http-equiv="Cache-control" content="public">
    <!--end of caching meta-->
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta meta name="viewport" content="width=device-width, user-scalable=no" />
    <!-- <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" /> -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    @if(Session::has('download.in.the.next.request'))
        <meta http-equiv="refresh" content="5;url={{ Session::get('download.in.the.next.request') }}">
    @endif
    <meta name="description" content="Welcome to Ondo State Ministry of Education, Science and Technology Website">
    <meta name="keywords" content="ondo state, education, start up design, software, code, tech, computer stuff, store, couture, html, css, javascript, websites, website development, web development, design, ui, ux , agboba gideon , agboba_gideon, agboba kehinde, agboba_kehinde" />
    <meta property="og:locale" content="en-US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ isset($title) ? $title.' : ' : ''}} Ondo Secondary School App" />
    <meta property="og:description" content="Welcome to Ondo State Ministry of Education, Science and Technology Website" />
    <meta property="og:url" content="" />
    <meta property="og:site-name" content="Ondo Secondary School App" />
    <meta property="article:publisher" content="Ondo Secondary School App" />
    <meta property="og:image" content="https://odsgmoe.com/eportal/public/images/header-logo.png" />
    <meta property="og:image:secure_url" content="https://odsgmoe.com/eportal/public/images/header-logo.png" />
    <meta property="og:image:width" content="312" />
    <meta property="og:image:height" content="313" />
    <meta name="twitter:card" content="summary" />
    <meta name="twitter:title" content="Ondo Secondary School App" />
    <meta name="twitter:site" content="@Ondo_Secondary_School_App" />
    <meta name="twitter:domain" content="Ondo Secondary School App" />
	<link rel="shortcut icon" href="{{url_public('/favicon.ico')}}" type="image/x-icon">
	<link rel="icon" href="{{url_public('/favicon.ico')}}" type="image/x-icon">
    <meta name="msapplication-TileColor" content="#ff7402">
    <meta name="msapplication-TileImage" content="{{url_public('/favicon.ico')}}">
    <link href="https://odsgmoe.com/eportal/public/css/overview.css" type="text/css" rel="stylesheet">
    <!--<link href="https://odsgmoe.com/eportal/public/overview/css/materialize.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/css/style.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/css/custom/custom.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/vendors/perfect-scrollbar/perfect-scrollbar.css" type="text/css" rel="stylesheet">-->
    <!--<link href="https://odsgmoe.com/eportal/public/overview/vendors/flag-icon/css/flag-icon.min.css" type="text/css" rel="stylesheet">-->
    <!-- INCLUDED PLUGIN CSS ON THIS PAGE -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    @yield('styles')
    <style>
        #loader-wrapper .loader-section{
            background: linear-gradient(to bottom, rgb(255, 154, 0), #FFC107) !important;
        }
        li.user-details{
            position: sticky;
            top: 0px;
            z-index: 2;
        }
        .material-tooltip{
            pointer-events: all !important;
            z-index: 3;
        }
        .backdrop {
            padding: 0px !important;
            margin: 0px;
            height: fit-content !important;
            pointer-events: all !important;
            z-index: 3 !important;
        }
        .quick-auth ul, .quick-auth li{
            text-align: left;
            font-size: 12px;
        }
        .quick-auth .header{
            font-size: 11px;
            color: rgba(0, 0, 0, 0.81);
        }
        .quick-auth .header b{
            color: #000;
        }
        .quick-auth a{
            color: #000;
            margin: 0px;
            text-transform: capitalize;
        }
        .quick-auth i{
            font-size: 12px;
        }
    </style>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script>
        window.onbeforeunload = function() {
          $('body').removeClass('loaded');
            // check if link contains the overview-app
            // if(window.location.href.indexOf("overview-app") > -1) {
            //     console.log('dude: '+window.location.href);
            // }else{
            //     window.location = '/overview-app';
            // }
        };
    </script>
	<!--<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>-->
	<!--<script data-ad-client="ca-pub-2725963369944173" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>-->
 <!--   <script>-->
 <!--     (adsbygoogle = window.adsbygoogle || []).push({-->
 <!--       google_ad_client: "ca-pub-2725963369944173",-->
 <!--       enable_page_level_ads: true-->
 <!--     });-->
 <!--   </script>-->
    <script data-ad-client="ca-pub-7258522889310876" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
    @if(isset($noAutoAd) && $noAutoAd == true)
    @else
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script> <script> (adsbygoogle = window.adsbygoogle || []).push({ google_ad_client: "ca-pub-2725963369944173", enable_page_level_ads: true }); </script>
    @endif
</head>
<body>
    <!-- Start Page Loading -->
    <div id="loader-wrapper">
      <div id="loader"></div>
      <div class="loader-section section-left"></div>
      <div class="loader-section section-right"></div>
    </div>
    <!-- End Page Loading -->
    
    <!-- START HEADER -->
    @include('result-app.layouts.navbar')
    <!-- END HEADER -->
    
    <!-- START MAIN -->
    <div id="main">
      <!-- START WRAPPER -->
      <div class="wrapper">
        <!-- START LEFT SIDEBAR NAV-->
        @include('result-app.layouts.sidebar')
        <!-- END LEFT SIDEBAR NAV-->
        <!-- //////////////////////////////////////////////////////////////////////////// -->
        <!-- START CONTENT -->
        <br>
        <section id="content" style="padding: 0px 10px 10px 10px;">
            <div class="container">
                @if(!isset($noTopAd))
                <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                <ins class="adsbygoogle"
                     style="display:block"
                     data-ad-format="fluid"
                     data-ad-layout-key="-fb+5w+4e-db+86"
                     data-ad-client="ca-pub-7258522889310876"
                     data-ad-slot="5383575424"></ins>
                <script>
                     (adsbygoogle = window.adsbygoogle || []).push({});
                </script>
                @endif
                @yield('content')
                <br>
                @include('layouts.ads.long-slim-ad')
            </div>
        </section>
        <!-- END CONTENT -->
        <!-- START RIGHT SIDEBAR NAV-->
        @include('result-app.layouts.right-sidebar')
        <!-- END RIGHT SIDEBAR NAV-->
      </div>
      <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->
    
    <!--QUICK AUTHS-->
    @include('result-app.layouts.quick-auth')
    <!--END QUICK AUTHS-->
    
    @if (Session::has('flash_notification'))
    <div class="alert-panel card-panel grey white-text" style="position: fixed;
    bottom: -15px;
    z-index: 999;
    padding: 20px 10px 0px 10px;
    pointer-events: all;
    width:100%;">
      <div class="row valign-wrapper">
        <div class="col s12">
          <span class="white-text">
            @include('flash::message')
          </span>
        </div>
        <div style="position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -120%);
        background: #9e9e9e;
        border-radius: 50%;
        padding: 8px 10px;">
          <i class="material-icons">close</i>
        </div>
      </div>
    </div>
    @endif
        
        
    
    <script type="text/javascript" src="https://odsgmoe.com/eportal/public/js/overview.js"></script>
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/vendors/jquery-3.2.1.min.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/js/materialize.min.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/vendors/perfect-scrollbar/perfect-scrollbar.min.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/js/plugins.js"></script>-->
    <!--<script type="text/javascript" src="https://odsgmoe.com/eportal/public/overview/js/custom-script.js"></script>-->
    <script>
    $(function(){
        $('.tooltipped').tooltip({html: true});
        $('.modal').modal();
        $('.modal-activator').click(function(){
            var modalClass = $(this).attr('data-modal');
            $(modalClass).modal('open');
        });
    });
    $('.alert-panel').each(function(){
        var alert = $(this);
        alert.find('i').on('click touchstart', e => {
            e.preventDefault();
            alert.remove();
        });
    });
    </script>
    @yield('scripts')
</body>
</html>