@extends('overview.layouts.main')
@section('content')
<div id="card-stats">
  <div class="row mt-1">
    <div class="col s12 m6 l3">
        <a href="{{url('/overview-app/teacher/attendance/class-student')}}">
          <div class="card gradient-45deg-amber-amber gradient-shadow min-height-100 white-text">
            <div class="padding-4">
              <div class="col s7 m7">
                <i class="material-icons background-round mt-5">people</i>
                <p>Class Students</p>
              </div>
              <div class="col s5 m5 right-align">
                <h5 class="mb-0">{{$today_class_student_attendance}}</h5>
                <p class="no-margin">Today</p>
                <p>{{number_format($all_class_student_attendance, 0)}}</p>
              </div>
            </div>
          </div>
        </a>
    </div>
    <div class="col s12 m6 l3">
        <a href="{{url('/overview-app/teacher/attendance/subject-student')}}">
          <div class="card gradient-45deg-red-pink gradient-shadow min-height-100 white-text">
            <div class="padding-4">
              <div class="col s7 m7">
                <i class="material-icons background-round mt-5">people_outline</i>
                <p>Subject Students</p>
              </div>
              <div class="col s5 m5 right-align">
                <h5 class="mb-0">{{$today_subject_student_attendance}}</h5>
                <p class="no-margin">Today</p>
                <p>{{number_format($all_subject_student_attendance, 0)}}</p>
              </div>
            </div>
          </div>
        </a>
    </div>
  </div>
</div>

<script>
var date;
var display = document.getElementById('time'); 
setInterval(function(){ 
    date = new Date();
    var currenthours = date.getHours();
    var hours;
    var minutes;
    var secondes;
    if (currenthours != 21){
        if (currenthours < 21)
            hours = 20 - currenthours;
        else hours = 21 + (24 - currenthours);
        minutes = 60 - date.getMinutes();
        secondes = 60 - date.getSeconds();
    display.innerHTML = hours + ':' + minutes + ':' +secondes;
    }
    else display.innerHTML = 'LIVE NOW';
},1000);
</script>
@endsection