@extends('overview.layouts.main')
@section('content')
<div id="card-widgets">
  <div class="row">
    <div class="col s12 m12 l4">
        <form class="formOne" action="" method="POST">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="type" value="search">
            <button type="submit" style="display: none;"></button>
            <div id="flight-card" class="card">
                <div class="card-header deep-orange accent-2">
                  <div class="card-title">
                    <h4 class="flight-card-title">Search Student</h4>
                    <p class="flight-card-date">Search students to mark class attendance</p>
                  </div>
                </div>
            </div>
            <div class="input-field col s12">
                <select type="text" name="session" required>
                    <option value="" disabled @if($session == 0) selected @endif>Select Session</option>
                    @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                    <option @if($session == $i) selected @endif value="{{$i}}">{{$i}}/{{$i+1}}</option>
                    @endfor
                </select>
                <label>Session Select</label>
            </div>
            <div class="input-field col s12">
                <select type="text" name="term" required>
                    <option value="" disabled @if($term == '') selected @endif>Select Term</option>
                    <option @if($term == 'First') selected @endif value="First">First Term</option>
                    <option @if($term == 'Second') selected @endif value="Second">Second Term</option>
                    <option @if($term == 'Third') selected @endif value="Third">Third Term</option>
                </select>
                <label>Term Select</label>
            </div>
            <div class="input-field col s12">
                <select type="text" id="classes_select" name="class_id" required>
                    <option value="{{$class_id}}">{{$class}}</option>
                </select>
                <label>Class Select</label>
            </div>
            <div class="input-field col s12">
                <select type="text" id="class_arm_select" name="class_arm_id" required>
                    @php error_reporting(0); $class_arm  = $teacher->classArm; @endphp
                    <option value="{{$class_arm->id}}" selected>{{strtoupper($class_arm->class_arm)}}</option>
                </select>
                <label>Class Arm Select</label>
            </div>
            <div class="input-field col s12">
                <button class="btn waves-effect waves-light deep-orange accent-2" onclick="$('form.formOne button[type=submit]').trigger('click');">Search</button>
            </div>
        </form>
    </div>
    @if(count($students) > 0)
    <div class="col s12 m4 l4">
        <form action="" method="POST">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="type" value="mark">
            @if($session != 0)
            <input type="hidden" value="{{$session}}" name="session" required>
            @endif
            @if($term != '')
            <input type="hidden" value="{{$term}}" name="term" required>
            @endif
            @if($class_id != 0)
            <input type="hidden" value="{{$class_id}}" name="class_id" required>
            @endif
            @if($class_arm_id)
            <input type="hidden" value="{{$class_arm_id->id}}" name="class_arm_id" required>
            @endif
          <ul id="task-card" class="collection with-header">
            <li class="collection-header amber accent-4">
              <h4 class="task-card-title">All class students</h4>
              <p class="task-card-date">{{$class}} pending students to mark</p>
            </li>
            <button class="btn-floating btn-large waves-effect waves-light red pinned" type="submit" style="right:5px;bottom:5px;"><i class="material-icons left">check</i></button>
            <li class="collection-item">
              <input type="checkbox" id="taskMain" onchange="toggleAllCheckbox(this);">
              <label for="taskMain">Select all </label>
            </li>
            @foreach($students as $student)
            <li class="collection-item">
              <input type="checkbox" name="student_id[]" value="{{$student->id}}" id="task{{$student->id}}" />
              <label for="task{{$student->id}}">{{$student->surname}} {{$student->firstname}} {{$student->middlename}}
                <a href="#" class="secondary-content">
                  <span class="ultra-small">{{$student->session}}</span>
                </a>
              </label>
              <span class="task-cat deep-orange accent-2">{{$student->regnum}}</span>
            </li>
            @endforeach
          </ul>
        </form>
        @include('overview.pagination.default', ['paginator' => $students])
    </div>
    @endif
  </div>
</div>
<script>
$(document).ready(function(){
    $('.tooltipped').tooltip();
});

function toggleAllCheckbox(obj){
    var input = $(obj);
    var form = $('form');
    var type = form.find('input[type=checkbox]');
    if(input.is(":checked")){
        type.each(function(){
            $(this).prop('checked', true);
        });
    }else{
        type.each(function(){
            $(this).prop('checked', false);
        });
    }
}

function getClasses(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {school_id: value, _token: token};
    url = select.attr('data-url');
    $('#classes_select').parents('.select-wrapper').first().addClass('disabled');
    $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#classes_select').removeClass('initialized');
            $('#classes_select').html(option);
            $('#classes_select').trigger('contentChanged');
            $('#classes_select').material_select();
            $('#classes_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch classes', 6000);
        }
    });
}

function getClassArms(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {class_id: value, _token: token};
    url = select.attr('data-url');
    $('#class_arm_select').parents('.select-wrapper').first().addClass('disabled');
    $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class Arm</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#class_arm_select').removeClass('initialized');
            $('#class_arm_select').html(option);
            $('#class_arm_select').trigger('contentChanged');
            $('#class_arm_select').material_select();
            $('#class_arm_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch class arms', 6000);
        }
    });
}
</script>
@endsection