@extends('overview.layouts.main')
@section('content')
<div id="card-widgets">
  <div class="row">
    <div class="col s12 m4 l4">
      <div id="profile-card" class="card">
        <div class="card-image waves-effect waves-block waves-light">
          <img class="activator" src="{{url_public('/images/profile.png')}}" alt="user bg">
        </div>
        <div class="card-content">
          <img src="{{url_public('/images/profile.png')}}" alt="" class="circle responsive-img activator card-profile-image gradient-45deg-amber-amber padding-2">
          <a class="btn-floating activator btn-move-up waves-effect waves-light red accent-2 z-depth-4 right">
            <i class="material-icons">edit</i>
          </a>
          <br>
          <span class="card-title activator grey-text text-darken-4">{{$user->fullname}}</span>
          <p>
            <i class="material-icons">perm_identity</i> Ministry Administrator</p>
          <p>
            <!--<i class="material-icons">perm_phone_msg</i> {{$user->phone}}</p>-->
          <p>
            <i class="material-icons">email</i> {{$user->email}}</p>
        </div>
        <div class="card-reveal">
          <span class="card-title grey-text text-darken-4">{{$user->fullname}}
            <i class="material-icons right">close</i>
          </span>
          <p>{{$user->username}}.</p>
          <p>
            <i class="material-icons">perm_identity</i> Ministry Administrator</p>
          <p>
            <!--<i class="material-icons">perm_phone_msg</i> {{$user->phone}}</p>-->
          <p>
            <i class="material-icons">email</i> {{$user->email}}</p>
          <p>
            <i class="material-icons">access_time</i> Created {{$user->created_at}}
          </p>
          <p>
          </p>
          <p>
            <i class="material-icons">adjust</i> Status: @if($user->status) active @else pending @endif
          </p>
          <p>
          </p>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection