@extends('overview.layouts.main')
@section('content')
<div>
    <div id="card-stats">
      <div class="row mt-1">
        <div class="col s12 m6 l3">
          <a href="{{url('/overview-app/ministry/attendance/administrator')}}">
          <div class="card gradient-45deg-light-blue-cyan gradient-shadow min-height-100 white-text">
            <div class="padding-4">
              <div class="col s7 m7">
                <i class="material-icons background-round mt-5">person_pin</i>
                <p>Administrators</p>
              </div>
              <div class="col s5 m5 right-align">
                <h5 class="mb-0">{{$today_admin_attendance}}</h5>
                <p class="no-margin">Today</p>
                <p>{{number_format($all_admin_attendance, 0)}}</p>
              </div>
            </div>
          </div>
          </a>
        </div>
        <div class="col s12 m6 l3">
            <a href="{{url('/overview-app/ministry/attendance/teacher')}}">
          <div class="card gradient-45deg-red-pink gradient-shadow min-height-100 white-text">
            <div class="padding-4">
              <div class="col s7 m7">
                <i class="material-icons background-round mt-5">person</i>
                <p>Teachers</p>
              </div>
              <div class="col s5 m5 right-align">
                <h5 class="mb-0">{{$today_teacher_attendance}}</h5>
                <p class="no-margin">Today</p>
                <p>{{number_format($all_teacher_attendance, 0)}}</p>
              </div>
            </div>
          </div>
          </a>
        </div>
        <div class="col s12 m6 l3">
            <a href="{{url('/overview-app/ministry/attendance/student')}}">
          <div class="card gradient-45deg-amber-amber gradient-shadow min-height-100 white-text">
            <div class="padding-4">
              <div class="col s7 m7">
                <i class="material-icons background-round mt-5">person_outline</i>
                <p>Students</p>
              </div>
              <div class="col s5 m5 right-align">
                <h5 class="mb-0">{{$today_student_attendance}}</h5>
                <p class="no-margin">Today</p>
                <p>{{number_format($all_student_attendance, 0)}}</p>
              </div>
            </div>
          </div>
          </a>
        </div>
      </div>
    </div>
    
    <div class="card">
      <div class="card-content chart">
          <span class="card-title">@if(isset($_GET['chart'])) {{ucfirst($_GET['chart'])}} @else Daily @endif Traffic:</span>
          <canvas id="myAreaChart" width="100%" height="30"></canvas>
          @if(isset($_GET['chart']) && $_GET['chart'] == 'daily')
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=weekly">
                  <button class="waves-effect waves-light btn amber">View Weekly Traffic</button>
              </a>
              <br>
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=monthly">
                  <button class="waves-effect waves-light btn orange">View Monthly Traffic</button>
              </a>
          @elseif(isset($_GET['chart']) && $_GET['chart'] == 'monthly')
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=daily">
                  <button class="waves-effect waves-light btn blue">View Daily Traffic</button>
              </a>
              <br>
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=weekly">
                  <button class="waves-effect waves-light btn orange">View Weekly Traffic</button>
              </a>
          @elseif(isset($_GET['chart']) && $_GET['chart'] == 'weekly')
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=daily">
                  <button class="waves-effect waves-light btn blue">View Daily Traffic</button>
              </a>
              <br>
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=monthly">
                  <button class="waves-effect waves-light btn orange">View Monthly Traffic</button>
              </a>
          @else
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=weekly">
                  <button class="waves-effect waves-light btn amber">View Weekly Traffic</button>
              </a>
              <br>
              <a href="{{url('/overview-app/ministry/dashboard')}}?chart=monthly">
                  <button class="waves-effect waves-light btn orange">View Monthly Traffic</button>
              </a>
          @endif
      </div>
    </div>
</div>

<script src="https://odsgmoe.com/eportal/public/js/chart.min.js"></script>
@if(isset($_GET['chart']) && $_GET['chart'] == 'daily')
<script>
    var chartUrl = 'https://' + window.location.hostname + '/eportal/get-daily-user-chart-data';
</script>
@elseif(isset($_GET['chart']) && $_GET['chart'] == 'monthly')
<script>
    var chartUrl = 'https://' + window.location.hostname + '/eportal/get-monthly-user-chart-data';
</script>
@elseif(isset($_GET['chart']) && $_GET['chart'] == 'weekly')
<script>
    var chartUrl = 'https://' + window.location.hostname + '/eportal/get-weekly-user-chart-data';
</script>
@else
<script>
    var chartUrl = 'https://' + window.location.hostname + '/eportal/get-daily-user-chart-data';
</script>
@endif
<script>
( function ( $ ) {

  var charts = {
    init: function () {
      // -- Set new default font family and font color to mimic Bootstrap's default styling
      Chart.defaults.global.defaultFontFamily = '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
      Chart.defaults.global.defaultFontColor = '#292b2c';

      this.ajaxGetPostMonthlyData();

    },

    ajaxGetPostMonthlyData: function () {
      var urlPath =  chartUrl;
      var request = $.ajax( {
        method: 'GET',
        url: urlPath
    } );

      request.done( function ( response ) {
        console.log( response );
        charts.createCompletedJobsChart( response );
      });
    },

    /**
     * Created the Completed Jobs Chart
     */
    createCompletedJobsChart: function ( response ) {

      var ctx = document.getElementById("myAreaChart");
      var myLineChart = new Chart(ctx, {
        type: 'line',
        data: {
          labels: response.months, // The response got from the ajax request containing all month names in the database
          datasets: [{
            label: "Traffic",
            lineTension: 0.3,
            backgroundColor: "rgba(2,117,216,0.2)",
            borderColor: "rgba(2,117,216,1)",
            pointRadius: 5,
            pointBackgroundColor: "rgba(2,117,216,1)",
            pointBorderColor: "rgba(255,255,255,0.8)",
            pointHoverRadius: 5,
            pointHoverBackgroundColor: "rgba(2,117,216,1)",
            pointHitRadius: 2,
            pointBorderWidth: 2,
            data: response.post_count_data // The response got from the ajax request containing data for the completed jobs in the corresponding months
          }],
        },
        options: {
          scales: {
            xAxes: [{
              time: {
                unit: 'date'
              },
              gridLines: {
                display: false
              },
              ticks: {
                maxTicksLimit: 7
              }
            }],
            yAxes: [{
              ticks: {
                min: 0,
                max: response.max, // The response got from the ajax request containing max limit for y axis
                maxTicksLimit: 5
              },
              gridLines: {
                color: "rgba(0, 0, 0, .125)",
              }
            }],
          },
          legend: {
            display: true
          }
        }
      });
    }
  };

  charts.init();

} )( jQuery );
</script>
@endsection