@extends('overview.layouts.main')
@section('content')
    <div id="work-collections">
      <div class="row">
        <div class="col s12 m12 l6">
            <div class="card" style="overflow: hidden;">
                <div class="card-image  waves-effect waves-block waves-light">
                    <img class="activator" src="{{url_public($student->passport)}}" style="filter: brightness(0.4);">
                    <span class="card-title activator white-text" style="width: -webkit-fill-available;">{{strtoupper($class)}} {{strtoupper($classarm)}}
                        <i class="material-icons right">more_vert</i>
                    </span>
                </div>
                <!--<img class="activator" src="{{url_public('/overview/images/gallary/19.png')}}">-->
              <div class="card-content">
                <p>
                    <span class="black-text">Today's class attendance</span><br>
                    <small class="grey-text">Status: </small> 
                    @if($today_class_attendance->count() > 0)
                    <small class="green-text">marked</small>
                    @else
                    <small class="amber-text">not marked</small>
                    @endif
                </p>
              </div>
              <div class="card-reveal" style="display: none; transform: translateY(0px);">
                <span class="card-title grey-text text-darken-4">
                    <i class="material-icons right">close</i>
                </span>
                <br>
                <ul class="collection">
                  <li class="collection-item">Name: <span class="val">{{$student->surname}} {{$student->firstname}} {{$student->middlename}}</span></li>
                  <li class="collection-item">Registration No: <span class="val">{{$student->regnum}}</span></li>
                  <li class="collection-item">Gender: <span class="val">{{$student->gender}}</span></li>
                  <li class="collection-item">Session: <span class="val">{{$student->session}}</span></li>
                  <li class="collection-item">School: <span class="val">{{$student->schools->name}}</span></li>
                  <li class="collection-item">Principal: <span class="val">{{$student->schools->principal_name}}</span></li>
                  @if($today_class_attendance->count() > 0)
                  <li class="collection-item">Marked: <span class="val">{{$today_class_attendance->first()->created_at->diffForHumans()}}</span></li>
                  <li class="collection-item">Marked By: <span class="val">{{$today_class_attendance->first()->teacher->surname}} {{$today_class_attendance->first()->teacher->firstname}} {{$today_class_attendance->first()->teacher->middlename}}</span></li>
                  @endif
                </ul>
              </div>
            </div>
        </div>
        <div class="col s12 m12 l6">
          <ul id="projects-collection" class="collection z-depth-1">
            <li class="collection-item avatar">
              <i class="material-icons cyan circle">assignment</i>
              <h6 class="collection-header m-0">Subjects Attendance</h6>
              <p>All subject attendance for today</p>
            </li>
            @if($today_subject_attendance->count() > 0)
            @foreach($today_subject_attendance as $attendance)
            @php $subject = $attendance->subject; $teacher = $attendance->teacher; @endphp
            <li class="collection-item">
              <div class="row">
                <div class="col s12">
                  <p class="collections-title">{{strtoupper($subject->subject_name)}} [{{$subject->subject_code}}]</p>
                  <p class="collections-content">Marked by {{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</p>
                  <small class="grey-text">{{$attendance->created_at->diffForHumans()}}</small>
                </div>
              </div>
            </li>
            @endforeach
            @else
            <li class="collection-item">
              <div class="row">
                <div class="col s9">
                  <p class="collections-title red-text">Opps!</p>
                  <p class="collections-content red-text">No subject marked for today</p>
                </div>
              </div>
            </li>
            @endif
          </ul>
        </div>
        <div class="col s12 m12 l6">
            <a style="margin-top: 5px;" href="{{route('overview-app.student.attendance')}}" class="waves-effect waves-light gradient-45deg-light-blue-cyan btn btn-large"><i class="material-icons left">assessment</i> {{$student->firstname}}'s attendance history</a>
        </div>
      </div>
    </div>
@endsection