<aside id="left-sidebar-nav">
    @if((Request::is('overview-app/ministry/*') || Request::is('overview-app/help')) && \Auth::guard('super_admin')->check())
    <ul id="slide-out" class="side-nav fixed leftside-navigation">
        <li class="user-details amber">
          <div class="row">
            <div class="col col s4 m4 l4">
              <img src="{{url_public('/images/profile.png')}}" alt="" class="circle responsive-img valign profile-image gradient-45deg-amber-amber">
            </div>
            <div class="col col s8 m8 l8">
              <h6 class="white-text" style="margin-bottom: -10px;">{{auth('super_admin')->user()->fullname}}</h6>
              <small class="white-text">Ministry Administrator</small>
            </div>
          </div>
        </li>
        <li class="no-padding">
          <ul class="collapsible" data-collapsible="accordion">
            <li class="bold">
              <a href="{{route('overview-app.super_admin.dashboard')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">pie_chart_outlined</i>
                  <span class="nav-text">Dashboard</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{url('/overview-app/ministry/attendance/administrator')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">person_pin_circle</i>
                  <span class="nav-text">Admins Attendance</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{url('/overview-app/ministry/attendance/teacher')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">person</i>
                  <span class="nav-text">Teachers Attendance</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{url('/overview-app/ministry/attendance/student')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">assignment_ind</i>
                  <span class="nav-text">Students Attendance</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.super_admin.profile')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">face</i>
                  <span class="nav-text">Profile</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.help')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">live_help</i>
                  <span class="nav-text">Help</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.super_admin.logout')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">keyboard_tab</i>
                  <span class="nav-text">Logout</span>
                </a>
            </li>
          </ul>
        </li>
    </ul>
    @elseif((Request::is('overview-app/admin/*') || Request::is('overview-app/help')) && \Auth::guard('admin')->check())
    <ul id="slide-out" class="side-nav fixed leftside-navigation">
        <li class="user-details amber">
          <div class="row">
            <div class="col col s4 m4 l4">
              <img src="{{url_public(auth('admin')->user()->schools->logo)}}" alt="" style="height: 50px;" class="circle responsive-img valign profile-image gradient-45deg-amber-amber">
            </div>
            <div class="col col s8 m8 l8">
              <h6 class="white-text" style="margin-bottom: -10px;">{{ucwords(auth('admin')->user()->schools->name)}}</h6>
              <small class="white-text">School Administrator</small>
            </div>
          </div>
        </li>
        <li class="no-padding">
          <ul class="collapsible" data-collapsible="accordion">
            <li class="bold">
              <a href="{{route('overview-app.admin.dashboard')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">pie_chart_outlined</i>
                  <span class="nav-text">Dashboard</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.admin.class.teacher')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">people</i>
                  <span class="nav-text">Assign Class Teacher</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.admin.subject.teacher')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">people_outline</i>
                  <span class="nav-text">Assign Subject Teacher</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{url('/overview-app/admin/attendance/teacher')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">person</i>
                  <span class="nav-text">Teachers Attendance</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{url('/overview-app/admin/attendance/student')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">assignment_ind</i>
                  <span class="nav-text">Students Attendance</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.admin.profile')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">face</i>
                  <span class="nav-text">Profile</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.help')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">live_help</i>
                  <span class="nav-text">Help</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.admin.logout')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">keyboard_tab</i>
                  <span class="nav-text">Logout</span>
                </a>
            </li>
          </ul>
        </li>
    </ul>
    @elseif((Request::is('overview-app/teacher/*') || Request::is('overview-app/help')) && \Auth::guard('teacher')->check())
    <ul id="slide-out" class="side-nav fixed leftside-navigation">
        <li class="user-details amber">
          <div class="row">
            <div class="col col s4 m4 l4">
              <img src="{{url_public(auth('teacher')->user()->schools->logo)}}" alt="" style="height: 50px;" class="circle responsive-img valign profile-image gradient-45deg-amber-amber">
            </div>
            <div class="col col s8 m8 l8">
              <h6 class="white-text" style="margin-bottom: -10px;">{{ucwords(auth('teacher')->user()->surname.' '.auth('teacher')->user()->firstname.' '.auth('teacher')->user()->middlename)}}</h6>
              <small class="white-text">
                    @if(App\ClassAttendanceAnalyticTeacher::where('teacher_id', auth('teacher')->user()->id)
                                                        ->where('class_id', '!=', 0)
                                                        ->where('school_id', auth('teacher')->user()->schools->id)
                                                        ->get()->count() > 0 && 
                        App\SubjectAttendanceAnalyticTeacher::where('teacher_id', auth('teacher')->user()->id)
                                                            ->where('subject_id', '!=', 0)
                                                            ->where('school_id', auth('teacher')->user()->schools->id)
                                                            ->get()->count() > 0)
                        Class & Subject teacher 
                    @elseif(App\ClassAttendanceAnalyticTeacher::where('teacher_id', auth('teacher')->user()->id)
                                                            ->where('class_id', '!=', 0)
                                                            ->where('school_id', auth('teacher')->user()->schools->id)
                                                            ->get()->count() > 0)
                        Class teacher 
                    @elseif(App\SubjectAttendanceAnalyticTeacher::where('teacher_id', auth('teacher')->user()->id)
                                                            ->where('subject_id', '!=', 0)
                                                            ->where('school_id', auth('teacher')->user()->schools->id)
                                                            ->get()->count() > 0) 
                        Subject teacher @else Teacher 
                    @endif
              </small>
            </div>
          </div>
        </li>
        <li class="no-padding">
          <ul class="collapsible" data-collapsible="accordion">
            <li class="bold">
              <a href="{{route('overview-app.teacher.dashboard')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">pie_chart_outlined</i>
                  <span class="nav-text">Dashboard</span>
                </a>
            </li>
            @if(App\ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->count() > 0)
            <li><div class="divider"></div></li>
            <li><a class="subheader">Class Attendance</a></li>
            <li class="bold">
              <a href="{{url('/overview-app/teacher/attendance/class-student')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">people</i>
                  <span class="nav-text">View Class Attendance</span>
                </a>
            </li>
            @foreach(App\ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get() as $classTeacher)
            <li class="bold">
              <a href="{{route('overview-app.teacher.class.attendance', ['class_id' => $classTeacher->id])}}" class="waves-effect waves-cyan">
                  <i class="material-icons">assignment</i>
                  <span class="nav-text">{{ucfirst($classTeacher->classes->class_name)}} {{strtoupper($classTeacher->classArm->class_arm)}}'s Attendance</span>
                </a>
            </li>
            @endforeach
            @endif
            @if(App\SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->count() > 0)
            <li><div class="divider"></div></li>
            <li><a class="subheader">Subject Attendance</a></li>
            <li class="bold">
              <a href="{{url('/overview-app/teacher/attendance/subject-student')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">people_outlined</i>
                  <span class="nav-text">View Subject Attendance</span>
                </a>
            </li>
            @foreach(App\SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get() as $subjectTeacher)
            <li class="bold">
              <a href="{{route('overview-app.teacher.subject.attendance', ['subject_id' => $subjectTeacher->id])}}" class="waves-effect waves-cyan">
                  <i class="material-icons">assignment</i>
                  <span class="nav-text">[{{strtoupper($subjectTeacher->classes->class_name)}} {{$subjectTeacher->classArm->class_arm}}] {{strtoupper($subjectTeacher->subject->subject_code)}} Attendance</span>
                </a>
            </li>
            @endforeach
            @endif
            <li><div class="divider"></div></li>
            <li class="bold">
              <a href="{{route('overview-app.teacher.profile')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">face</i>
                  <span class="nav-text">Profile</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.help')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">live_help</i>
                  <span class="nav-text">Help</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.teacher.logout')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">keyboard_tab</i>
                  <span class="nav-text">Logout</span>
                </a>
            </li>
          </ul>
        </li>
    </ul>
    @elseif((Request::is('overview-app/student/*') || Request::is('overview-app/help')) && \Auth::guard('student')->check())
    <ul id="slide-out" class="side-nav fixed leftside-navigation">
        <li class="user-details amber">
          <div class="row">
            <div class="col col s4 m4 l4">
              <img src="{{url_public(auth('student')->user()->passport)}}" alt="" style="height: 50px;" class="circle responsive-img valign profile-image gradient-45deg-amber-amber">
            </div>
            <div class="col col s8 m8 l8">
              <h6 class="white-text" style="margin-bottom: -10px;">{{ucwords(auth('student')->user()->surname.' '.auth('student')->user()->firstname.' '.auth('student')->user()->middlename)}}</h6>
              <small class="white-text">Student</small>
            </div>
          </div>
        </li>
        <li class="no-padding">
          <ul class="collapsible" data-collapsible="accordion">
            <li class="bold">
              <a href="{{route('overview-app.student.dashboard')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">pie_chart_outlined</i>
                  <span class="nav-text">Dashboard</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.student.attendance')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">assessment</i>
                  <span class="nav-text">{{ucfirst(auth('student')->user()->firstname)}}'s Attendance</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.help')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">live_help</i>
                  <span class="nav-text">Help</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.student.logout')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">keyboard_tab</i>
                  <span class="nav-text">Logout</span>
                </a>
            </li>
          </ul>
        </li>
    </ul>
    @else
    <ul id="slide-out" class="side-nav fixed leftside-navigation">
        <li class="user-details amber">
          <div class="row">
            <div class="col col s4 m4 l4">
              <img src="https://odsgmoe.com/eportal/public/images/header-logo.png" alt="" style="height: 50px;" class="responsive-img valign profile-image">
            </div>
            <div class="col col s8 m8 l8">
              <h6 class="white-text" style="margin-bottom: -10px;">ODSGMOE</h6>
              <small class="white-text">Guest</small>
            </div>
          </div>
        </li>
        <li class="no-padding">
          <ul class="collapsible" data-collapsible="accordion">
            <li class="bold">
              <a href="{{url('overview-app')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">home</i>
                  <span class="nav-text">Home</span>
                </a>
            </li>
            <li class="bold">
              <a href="{{route('overview-app.help')}}" class="waves-effect waves-cyan">
                  <i class="material-icons">live_help</i>
                  <span class="nav-text">Help</span>
                </a>
            </li>
          </ul>
        </li>
    </ul>
    @endif
  <a href="" style="margin-top: 1px" data-activates="slide-out" class="sidebar-collapse btn-floating amber btn-medium waves-effect waves-light hide-on-large-only">
    <i class="material-icons">menu</i>
  </a>
</aside>