@if(Auth::guard('super_admin')->check() || Auth::guard('admin')->check() || Auth::guard('teacher')->check() || Auth::guard('student')->check())
    <div class="fixed-action-btn" style="right: auto;left: 10px;bottom: 10px;">
      <a class="btn-floating btn-large cyan darken-2" data-hoverEnabled="true">
        <i class="large material-icons">account_circle</i>
      </a>
      <ul>
        @if(Auth::guard('super_admin')->check())
        <li>
            <a class="btn-floating red"><i class="material-icons tooltipped" data-position="right" data-tooltip='<ul class="collection quick-auth">
                <li class="collection-item"><span class="header"><small>Logged in as: </small><br>{{auth('super_admin')->user()->fullname}}<br><b>Ministry Account</b></span></li>
                @if(Request::is('overview-app/ministry/*') == false)<li class="collection-item"><a href="{{route('overview-app.super_admin.dashboard')}}"><i class="material-icons">repeat</i> Switch Account</a></li>@endif
                <li class="collection-item"><a href="{{route('overview-app.super_admin.logout')}}"><i class="material-icons">keyboard_return</i> Logout</a></li>
            </ul>'>person_pin</i></a>
        </li>
        @endif
        @if(Auth::guard('admin')->check())
        <li>
            <a class="btn-floating amber"><i class="material-icons tooltipped" data-position="right" data-tooltip='<ul class="collection quick-auth">
                <li class="collection-item"><span class="header"><small>Logged in as: </small><br>{{auth('admin')->user()->fullname}}<br><b>Admin Account</b></span></li>
                @if(Request::is('overview-app/admin/*') == false)<li class="collection-item"><a href="{{route('overview-app.admin.dashboard')}}"><i class="material-icons">repeat</i> Switch Account</a></li>@endif
                <li class="collection-item"><a href="{{route('overview-app.admin.logout')}}"><i class="material-icons">keyboard_return</i> Logout</a></li>
            </ul>'>person_outline</i></a>
        </li>
        @endif
        @if(Auth::guard('teacher')->check())
        <li>
            <a class="btn-floating blue"><i class="material-icons tooltipped" data-position="right" data-tooltip='<ul class="collection quick-auth">
                <li class="collection-item"><span class="header"><small>Logged in as: </small><br>{{auth('teacher')->user()->surname}} {{auth('teacher')->user()->firstname}}<br><b>Teacher Account</b></span></li>
                @if(Request::is('overview-app/teacher/*') == false)<li class="collection-item"><a href="{{route('overview-app.teacher.dashboard')}}"><i class="material-icons">repeat</i> Switch Account</a></li>@endif
                <li class="collection-item"><a href="{{route('overview-app.teacher.logout')}}"><i class="material-icons">keyboard_return</i> Logout</a></li>
            </ul>'>person</i></a>
        </li>
        @endif
        @if(Auth::guard('student')->check())
        <li>
            <a class="btn-floating green"><i class="material-icons tooltipped" data-position="right" data-tooltip='<ul class="collection quick-auth">
                <li class="collection-item"><span class="header"><small>Logged in as: </small><br>{{auth('student')->user()->surname}} {{auth('student')->user()->firstname}}<br><b>Student Account</b></span></li>
                @if(Request::is('overview-app/student/*') == false)<li class="collection-item"><a href="{{route('overview-app.student.dashboard')}}"><i class="material-icons">repeat</i> Switch Account</a></li>@endif
                <li class="collection-item"><a href="{{route('overview-app.student.logout')}}"><i class="material-icons">keyboard_return</i> Logout</a></li>
            </ul>'>assignment_ind</i></a>
        </li>
        @endif
        <li>
            <a href="{{url('/overview-app')}}" class="btn-floating indigo"><i class="material-icons tooltipped" data-position="right" data-tooltip='Login into another account'>add</i></a>
        </li>
      </ul>
    </div>
@endif