@extends('overview.layouts.main')
@section('content')
<div id="card-widgets">
  <div class="row">
    <div class="col s12 m4 l4">
        <form action="" method="POST">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
          <ul id="task-card" class="collection with-header">
            <li class="collection-header amber accent-4">
              <h4 class="task-card-title">All teachers</h4>
              <p class="task-card-date">Select from today pending teachers to mark</p>
            </li>
            @if(count($attendance) > 0)
            <button class="btn-floating btn-large waves-effect waves-light red pinned" type="submit" style="right:5px;bottom:5px;"><i class="material-icons left">check</i></button>
            <li class="collection-item">
              <input type="checkbox" id="taskMain" onchange="toggleAllCheckbox(this);">
              <label for="taskMain">Select all </label>
            </li>
            @foreach($attendance as $teacher)
            <li class="collection-item">
              <input type="checkbox" name="teacher_id[]" value="{{$teacher->id}}" id="task{{$teacher->id}}" />
              <label for="task{{$teacher->id}}">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}
                <a href="#" class="secondary-content">
                  <span class="ultra-small">{{$teacher->gender}}</span>
                </a>
              </label>
              <span class="task-cat deep-orange accent-2">{{$teacher->staff_no}}</span>
            </li>
            @endforeach
            @else
            <div style="color:red;text-align:center;padding:20px;">
                <small>
                    No available record
                </small>
            </div>
            @endif
          </ul>
        </form>
        @include('overview.pagination.default', ['paginator' => $attendance])
    </div>
  </div>
</div>
<script>
function toggleAllCheckbox(obj){
    var input = $(obj);
    var form = $('form');
    var type = form.find('input[type=checkbox]');
    if(input.is(":checked")){
        type.each(function(){
            $(this).prop('checked', true);
        });
    }else{
        type.each(function(){
            $(this).prop('checked', false);
        });
    }
}
</script>
@endsection