@extends('overview.layouts.main')
@section('content')
<div id="card-widgets">
    <div class="row">
        <div class="col s12 m12 l4">
            <form class="formOne" action="" method="POST">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
                <input type="hidden" name="action" value="create" />
                <button type="submit" style="display: none;"></button>
                <div id="flight-card" class="card">
                    <div class="card-header deep-orange accent-2">
                      <div class="card-title">
                        <h4 class="flight-card-title">Search Teacher</h4>
                        <p class="flight-card-date">Search subject teacher</p>
                      </div>
                    </div>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="teacher_id" required>
                      <option value="" disabled selected>Select Teacher</option>
                      @foreach($teachers as $teacher)
                        <option value="{{$teacher->id}}">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</option>
                      @endforeach
                    </select>
                    <label>Teacher Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="class_id" onchange="getClassArms(this)" data-url="{{route('overview-app.api.get-class-arms')}}" required>
                      <option value="" disabled selected>Select Class</option>
                      @foreach($classes as $class)
                        <option value="{{$class->id}}">{{strtoupper($class->class_name)}}</option>
                      @endforeach
                    </select>
                    <label>Class Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" id="class_arm_select" name="class_arm_id" required>
                        <option value="" disabled selected>Select Class Arm</option>
                    </select>
                    <label>Class Arm Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="subject_id" required>
                      <option value="" disabled selected>Select Subject</option>
                      @foreach($subjects as $subject)
                        <option value="{{$subject->id}}">[{{$subject->subject_code}}] {{$subject->subject_name}} | {{$subject->class_category}}</option>
                      @endforeach
                    </select>
                    <label>Subject Select</label>
                </div>
                <div class="input-field col s12">
                    <button class="btn waves-effect waves-light deep-orange accent-2" onclick="$('form.formOne button[type=submit]').trigger('click');">Submit</button>
                </div>
            </form>
        </div>
        <br><br><br>
        <div class="col s12 m4 l4">
            <form action="" method="POST">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
                <input type="hidden" name="action" value="delete" />
              <ul id="task-card" class="collection with-header">
                <li class="collection-header amber accent-4">
                  <h4 class="task-card-title">Subject teachers</h4>
                  <p class="task-card-date">Select subject teachers to delete</p>
                </li>
                @if(count($subject_teachers) > 0)
                <button class="btn-floating btn-large waves-effect waves-light red pinned" type="submit" style="right:5px;bottom:5px;"><i class="material-icons left">delete</i></button>
                <li class="collection-item">
                  <input type="checkbox" id="taskMain" onchange="toggleAllCheckbox(this);">
                  <label for="taskMain">Select all </label>
                </li>
                @php $counter = 1; @endphp
                @foreach($subject_teachers as $list)
                @php $teacher = $list->teacher; $subject = $list->subject; $classArm = $list->classArm; @endphp
                <li class="collection-item">
                  <input type="checkbox" name="teacher_id[]" value="{{$list->id}}" id="task{{$counter}}" />
                  <label for="task{{$counter}}">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}
                    <a href="#" class="secondary-content">
                      <span class="ultra-small">{{$list->created_at->diffForHumans()}}</span>
                    </a>
                  </label>
                  <span class="task-cat deep-orange accent-2 tooltipped" data-position="bottom" data-tooltip="{{$subject->subject_name}}">{{$subject->subject_code}} | {{$subject->class_category}}  {{strtoupper($classArm->class_arm)}}</span>
                </li>
                @php $counter++; @endphp
                @endforeach
                @else
                <div style="color:red;text-align:center;padding:20px;">
                    <small>
                        No available record
                    </small>
                </div>
                @endif
              </ul>
            </form>
            @include('overview.pagination.default', ['paginator' => $subject_teachers])
        </div>
    </div>
</div>
<script>
function toggleAllCheckbox(obj){
    var input = $(obj);
    var form = $('form');
    var type = form.find('input[type=checkbox]');
    if(input.is(":checked")){
        type.each(function(){
            $(this).prop('checked', true);
        });
    }else{
        type.each(function(){
            $(this).prop('checked', false);
        });
    }
}

function getClasses(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {school_id: value, _token: token};
    url = select.attr('data-url');
    $('#classes_select').parents('.select-wrapper').first().addClass('disabled');
    $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#classes_select').removeClass('initialized');
            $('#classes_select').html(option);
            $('#classes_select').trigger('contentChanged');
            $('#classes_select').material_select();
            $('#classes_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch classes', 6000);
        }
    });
}

function getClassArms(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {class_id: value, _token: token};
    url = select.attr('data-url');
    $('#class_arm_select').parents('.select-wrapper').first().addClass('disabled');
    $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class Arm</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#class_arm_select').removeClass('initialized');
            $('#class_arm_select').html(option);
            $('#class_arm_select').trigger('contentChanged');
            $('#class_arm_select').material_select();
            $('#class_arm_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch class arms', 6000);
        }
    });
}
</script>
@endsection