  @extends('overview.layouts.main')
@section('content')
<div id="card-widgets">
  <div class="row">
    @if($today_attendance->count() > 0)
    <div class="col s12 m12 l4">
      <div id="flight-card" class="card">
        <div class="card-header deep-orange accent-2">
          <div class="card-title">
            <h4 class="flight-card-title">Today's Attendance</h4>
            <p class="flight-card-date">Marked {{$today_attendance->first()->created_at->diffForHumans()}}</p>
          </div>
        </div>
      </div>
    </div>
    @else
    <div class="col s12 m4 l4">
        <form action="" method="POST" class="today__attendance__form">
            <input type="hidden" name="_token" value="{{csrf_token()}}" />
          <ul id="task-card" class="collection with-header">
            <li class="collection-header teal accent-4">
                <h4 class="task-card-title">Today's Attendance</h4>
                <p class="white-text task-card-date" style="display:flex;">
                    <i class="material-icons">access_time</i> <span style="margin: 3px 0px 0px 2px;">Expires in: <span class="white-text" id='time'></span></span>
                </p>
            </li>
            <li class="collection-item">
              <input type="checkbox" onchange="$('.today__attendance__form').submit()" id="task1" />
              <label for="task1">Mark
                <a href="#" class="secondary-content">
                  <span class="ultra-small">Today</span>
                </a>
              </label>
            </li>
          </ul>
        </form>
    </div>
    @endif
  </div>
</div>
<div id="card-stats">
  <div class="row mt-1">
    <div class="col s12 m6 l3">
        <a href="{{url('/overview-app/admin/attendance/teacher')}}">
          <div class="card gradient-45deg-red-pink gradient-shadow min-height-100 white-text">
            <div class="padding-4">
              <div class="col s7 m7">
                <i class="material-icons background-round mt-5">person</i>
                <p>Teachers</p>
              </div>
              <div class="col s5 m5 right-align">
                <h5 class="mb-0">{{$today_teacher_attendance}}</h5>
                <p class="no-margin">Today</p>
                <p>{{number_format($all_teacher_attendance, 0)}}</p>
              </div>
            </div>
          </div>
        </a>
    </div>
    <div class="col s12 m6 l3">
        <a href="{{url('/overview-app/admin/attendance/student')}}">
      <div class="card gradient-45deg-amber-amber gradient-shadow min-height-100 white-text">
        <div class="padding-4">
          <div class="col s7 m7">
            <i class="material-icons background-round mt-5">person_outline</i>
            <p>Students</p>
          </div>
          <div class="col s5 m5 right-align">
            <h5 class="mb-0">{{$today_student_attendance}}</h5>
            <p class="no-margin">Today</p>
            <p>{{number_format($all_student_attendance, 0)}}</p>
          </div>
        </div>
      </div>
      </a>
    </div>
  </div>
</div>
<a style="margin-top: 5px;" href="{{route('overview-app.admin.class.teacher')}}" class="waves-effect waves-light gradient-45deg-light-blue-cyan btn btn-large"><i class="material-icons left">people</i> Assign Class Teachers</a>
<br>
<a style="margin-top: 20px;" href="{{route('overview-app.admin.subject.teacher')}}" class="waves-effect waves-light gradient-45deg-green-teal btn btn-large"><i class="material-icons left">people_outline</i> Assign Subject Teachers</a>
<br><br>
<script>
var date;
var display = document.getElementById('time'); 
setInterval(function(){ 
    date = new Date();
    var currenthours = date.getHours();
    var hours;
    var minutes;
    var secondes;
    if (currenthours != 21){
        if (currenthours < 21)
            hours = 20 - currenthours;
        else hours = 21 + (24 - currenthours);
        minutes = 60 - date.getMinutes();
        secondes = 60 - date.getSeconds();
    display.innerHTML = hours + ':' + minutes + ':' +secondes;
    }
    else display.innerHTML = 'LIVE NOW';
},1000);
</script>
@endsection