@extends('overview.layouts.main')
@section('content')
<style>
    label{
        text-decoration: none !Important;
    }
</style>
<div id="card-widgets">
@if($type == 'teacher') 
    <div class="row">
        <div class="col s12 m12 l4">
            <a href="{{route('overview-app.admin.teachers.attendance')}}">
              <div id="flight-card" class="card">
                <div class="card-header deep-orange accent-2">
                  <div class="card-title">
                    <h4 class="flight-card-title">Mark Attendance</h4>
                    <p class="flight-card-date">Click to mark teachers attendance for today</p>
                  </div>
                </div>
              </div>
            </a>
        </div>
        <div class="col s12 m12 l4">
            <form class="formOne" action="" method="POST">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
                <button type="submit" style="display: none;"></button>
                <div id="flight-card" class="card">
                    <div class="card-header deep-orange accent-2">
                      <div class="card-title">
                        <h4 class="flight-card-title">Search Teacher</h4>
                        <p class="flight-card-date">View teachers attendance</p>
                      </div>
                    </div>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="date" required>
                      <option value="" disabled @if($date == '') selected @endif>Select Date</option>
                      <option @if($date == 'today') selected @endif value="today">Today</option>
                      <option @if($date == 'yesterday') selected @endif value="yesterday">Yesterday</option>
                      <option @if($date == 'this_week') selected @endif value="this_week">This Week</option>
                      <option @if($date == 'this_month') selected @endif value="this_month">This Month</option>
                      <option @if($date == 'all') selected @endif value="all">All</option>
                    </select>
                    <label>Date Select</label>
                </div>
                <div class="input-field col s12">
                    <button class="btn waves-effect waves-light deep-orange accent-2" onclick="$('form.formOne button[type=submit]').trigger('click');">Search</button>
                </div>
            </form>
        </div>
        <div class="col s12 m4 l4">
          <ul id="task-card" class="collection with-header">
            <li class="collection-header teal accent-4">
              <h4 class="task-card-title">{{ucfirst($type)}} Attendance</h4>
              <p class="task-card-date">Today's attendance: {{$attendance_count}}</p>
            </li>
            @if($attendance_count > 0)
            @foreach($attendance as $list)
            @php $teacher = $list->teacher; error_reporting(0); @endphp
            @if($teacher->surname != '' && $teacher->surname != null && $teacher->surname != undefined) 
            <li class="collection-item modal-activator" data-modal="#teacherModal{{$teacher->id}}">
              <input type="checkbox" checked="checked" disabled="disabled" />
              <label style=""text-decoration: none !important;>{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}
                <a class="secondary-content">
                  <span class="ultra-small">{{$teacher->gender}}</span>
                </a>
              </label>
              <span class="task-cat deep-orange accent-2">{{$teacher->staff_no}}</span>
              <br>
              <small class="grey-text" style="margin-left:35px;">{{$list->created_at->diffForHumans()}}</small>
            </li>
            <!-- Modal --> 
            <div id="teacherModal{{$teacher->id}}" class="modal bottom-sheet">
                <div class="modal-content">
                  <div class="row">
                    <div class="col s2">
                      <img src="{{url_public($teacher->passport)}}" alt="" class="circle responsive-img"> <!-- notice the "circle" class -->
                    </div>
                    <div class="col s10">
                      <span class="black-text">
                        <span class="grey-text">Full Name:</span> <span class="text-transform: capitalize;">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</span><br>
                        <span class="grey-text">Staff No:</span> <span>{{$teacher->staff_no}}</span><br>
                        <span class="grey-text">Gender:</span> <span>{{$teacher->gender}}</span><br>
                        <span class="grey-text">Session:</span> <span>{{$teacher->session}}</span><br>
                        <span class="grey-text">Type:</span> <span>
                            @if(App\ClassAttendanceAnalyticTeacher::where('teacher_id', $teacher->id)
                                                                    ->where('class_id', '!=', 0)
                                                                    ->where('school_id', $teacher->schools->id)
                                                                    ->get()->count() > 0 && 
                                App\SubjectAttendanceAnalyticTeacher::where('teacher_id', $teacher->id)
                                                                    ->where('subject_id', '!=', 0)
                                                                    ->where('school_id', $teacher->schools->id)
                                                                    ->get()->count() > 0)
                                Class & Subject teacher 
                            @elseif(App\ClassAttendanceAnalyticTeacher::where('teacher_id', $teacher->id)
                                                                    ->where('class_id', '!=', 0)
                                                                    ->where('school_id', $teacher->schools->id)
                                                                    ->get()->count() > 0)
                                Class teacher 
                            @elseif(App\SubjectAttendanceAnalyticTeacher::where('teacher_id', $teacher->id)
                                                                    ->where('subject_id', '!=', 0)
                                                                    ->where('school_id', $teacher->schools->id)
                                                                    ->get()->count() > 0) 
                                Subject teacher @else Teacher 
                            @endif</span><br>
                        <span class="grey-text">Marked:</span> <span>{{$list->created_at}}</span>
                      </span>
                    </div>
                  </div>
                </div>
            </div>
            @endif
            @endforeach
            @else
            <div style="color:red;text-align:center;padding:20px;">
                <small>
                    No available record
                </small>
            </div>
            @endif
          </ul>
          @include('overview.pagination.default', ['paginator' => $attendance])
        </div>
    </div>
@elseif($type == 'student')
    <div class="row">
        <div class="col s12 m12 l4">
            <form class="formOne" action="" method="POST">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
                <button type="submit" style="display: none;"></button>
                <div id="flight-card" class="card">
                    <div class="card-header deep-orange accent-2">
                      <div class="card-title">
                        <h4 class="flight-card-title">Search Student</h4>
                        <p class="flight-card-date">View students attendance</p>
                      </div>
                    </div>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="date" required>
                      <option value="" disabled @if($date == '') selected @endif>Select Date</option>
                      <option @if($date == 'today') selected @endif value="today">Today</option>
                      <option @if($date == 'yesterday') selected @endif value="yesterday">Yesterday</option>
                      <option @if($date == 'this_week') selected @endif value="this_week">This Week</option>
                      <option @if($date == 'this_month') selected @endif value="this_month">This Month</option>
                      <option @if($date == 'all') selected @endif value="all">All</option>
                    </select>
                    <label>Date Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="session" required>
                        <option value="" disabled @if($session == 0) selected @endif>Select Session</option>
                        @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                        <option @if($session == $i) selected @endif value="{{$i}}">{{$i}}/{{$i+1}}</option>
                        @endfor
                    </select>
                    <label>Session Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="term" required>
                        <option value="" disabled @if($term == '') selected @endif>Select Term</option>
                        <option @if($term == 'First') selected @endif value="First">First Term</option>
                        <option @if($term == 'Second') selected @endif value="Second">Second Term</option>
                        <option @if($term == 'Third') selected @endif value="First">Third Term</option>
                    </select>
                    <label>Term Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" id="classes_select" name="class_id"  onchange="getClassArms(this)" data-url="{{route('overview-app.api.get-class-arms')}}" required>
                        <option value="" disabled @if($class_id == 0) selected @endif>Select Class</option>
                        @if($school_id != 0)
                        @foreach(getClasses($school_id) as $class)
                        <option @if($class_id == $class->id) selected @endif value="{{$class->id}}">{{$class->class_name}}</option>
                        @endforeach
                        @endif
                    </select>
                    <label>Class Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" id="class_arm_select" name="class_arm_id" required>
                        <option value="" disabled @if($class_arm_id == '') selected @endif>Select Class Arm</option>
                        @if($class_id != 0)
                        @php error_reporting(0); @endphp
                        @foreach(getClassArms($class_id) as $arm)
                        <option @if($class_arm_id == $arm->id) selected @endif value="{{$arm->id}}">{{$arm->class_arm}}</option>
                        @endforeach
                        @endif
                    </select>
                    <label>Class Arm  Select</label>
                </div>
                <div class="input-field col s12">
                    <select type="text" name="subject_id" required>
                      <option value="" disabled @if($subject_id == '') selected @endif>Select Subject</option>
                      <option @if($subject_id == 0) selected @endif value="0">None</option>
                      @foreach(App\Subject::all() as $subject)
                        <option @if($subject_id == $subject->id) selected @endif value="{{$subject->id}}">{{$subject->class_category}} - {{strtoupper($subject->subject_name)}} [{{$subject->subject_code}}]</option>
                      @endforeach
                    </select>
                    <label>Subject Select</label>
                </div>
                <div class="input-field col s12">
                    <button class="btn waves-effect waves-light deep-orange accent-2" onclick="$('form.formOne button[type=submit]').trigger('click');">Search</button>
                </div>
            </form>
        </div>
        <div class="col s12 m4 l4">
          <ul id="task-card" class="collection with-header">
            <li class="collection-header teal accent-4">
              <h4 class="task-card-title">{{ucfirst($type)}} Attendance</h4>
              <p class="task-card-date">Total attendance: {{$attendance_count}}</p>
            </li>
            @if($attendance_count > 0)
            @foreach($attendance as $student)
            @php error_reporting(0); @endphp
            <li class="collection-item modal-activator" data-modal="#studentModal{{$student->id}}">
              <input type="checkbox" checked="checked" disabled="disabled" />
              <label style=""text-decoration: none !important;>{{$student->surname}} {{$student->firstname}} {{$student->middlename}}
                <a class="secondary-content">
                  <span class="ultra-small">{{$student->gender}}</span>
                </a>
              </label>
              <span class="task-cat deep-orange accent-2">{{$student->regnum}}</span>
              <br>
              @if($subject_id == 0)
              <small class="grey-text" style="margin-left:35px;">marked {{$student->classAttendanceAnalyticLog->last()->created_at->diffForHumans()}}</small>
              @else
              <small class="grey-text" style="margin-left:35px;">marked {{$student->subjectAttendanceAnalyticLog->last()->created_at->diffForHumans()}}</small>
              @endif
            </li>
            <!-- Modal --> 
            <div id="studentModal{{$student->id}}" class="modal bottom-sheet">
                <div class="modal-content">
                  <div class="row">
                    <div class="col s2">
                      <img src="{{url_public($student->passport)}}" alt="" class="circle responsive-img"> <!-- notice the "circle" class -->
                    </div>
                    <div class="col s10">
                      <span class="black-text">
                        <span class="grey-text">Full Name:</span> <span class="text-transform: capitalize;">{{$student->surname}} {{$student->firstname}} {{$student->middlename}}</span><br>
                        <span class="grey-text">OSSI Number:</span> <span>{{$student->regnum}}</span><br>
                        <span class="grey-text">Gender:</span> <span>{{$student->gender}}</span><br>
                        <span class="grey-text">Session:</span> <span>{{$student->session}}</span><br>
                        <span class="grey-text">Class:</span> <span>{{getClassNameByClassID($student->classarms[0]->pivot->class_id)}}</span><br>
                        <span class="grey-text">Class Arm:</span> <span>{{getClassArmNameByClassArmID($student->classarms[0]->pivot->classarm_id)}}</span><br>
                        @if($subject_id == 0)
                        <span class="grey-text">Marked:</span> <span>{{$student->classAttendanceAnalyticLog->last()->created_at}}</span>
                        @else
                        <span class="grey-text">Marked:</span> <span>{{$student->subjectAttendanceAnalyticLog->last()->created_at}}</span>
                        @endif
                      </span>
                    </div>
                  </div>
                </div>
            </div>
            @endforeach
            @else
            <div style="color:red;text-align:center;padding:20px;">
                <small>
                    No available record
                </small>
            </div>
            @endif
          </ul>
            @include('overview.pagination.default', ['paginator' => $attendance])
        </div>
      </div>
@endif
</div>
<script>
$(document).ready(function(){
    $('.tooltipped').tooltip();
});

function getClasses(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {school_id: value, _token: token};
    url = select.attr('data-url');
    $('#classes_select').parents('.select-wrapper').first().addClass('disabled');
    $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#classes_select').removeClass('initialized');
            $('#classes_select').html(option);
            $('#classes_select').trigger('contentChanged');
            $('#classes_select').material_select();
            $('#classes_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#classes_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch classes', 6000);
        }
    });
}

function getClassArms(obj){
    var select, value, url, data, token, option;
    select = $(obj);
    value = select.val();
    token = $('input[name=_token]').first().val();
    data = {class_id: value, _token: token};
    url = select.attr('data-url');
    $('#class_arm_select').parents('.select-wrapper').first().addClass('disabled');
    $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'none');
    // throw ajax
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            option = `<option value="" disabled selected >Select Class Arm</option>`;
            $.each(res.data, function(index, value){
                option += `<option value="${value.id}">${value.name.toUpperCase()}</option>`;
            });
            console.log(option);
            $('#class_arm_select').removeClass('initialized');
            $('#class_arm_select').html(option);
            $('#class_arm_select').trigger('contentChanged');
            $('#class_arm_select').material_select();
            $('#class_arm_select').parents('.select-wrapper').first().removeClass('disabled');
            $('#class_arm_select').parents('.select-wrapper').first().css('pointer-events', 'all');
        },
        error: function(err){
            Materialize.toast('Failed to fetch class arms', 6000);
        }
    });
}
</script>
@endsection