@if(Auth::guard('super_admin')->check() || Auth::guard('admin')->check() || Auth::guard('teacher')->check() || Auth::guard('student')->check())
    @if(Auth::guard('super_admin')->check())
        @php
            $user = Auth::guard('super_admin')->user();
            $loginCount = $user->login_count;
            $updateLevel = $user->update_level;
            $name = ucwords($user->fullname).' (@'.strtolower($user->username).')';
        @endphp
        @if($updateLevel == 0)
        <div class="ui medium modal updateNotifierModal" style="margin-top:0px !important;">
            <i class="close icon"></i> 
            <div class="description">
                <div class="ui icon message teal">
                  <i class="bell icon"></i>
                  <div class="content">
                    <div class="header">
                      Hello <b>{{ucwords($name)}}</b>,
                    </div>
                    <ul>
                        @if($loginCount < 2)
                        <li style="margin-top:5px;">
                            Welcome <b>Ministry User</b> to Ondo State Ministry of Education, Science and Technology Website. It's your first time on this platform, we suggest you change your account password.
                        </li>
                        @endif
                        @if($loginCount > 1 &&  $updateLevel == 0)
                        <li style="margin-top:10px;">
                            Welcome back to Ondo State Ministry of Education, Science and Technology Website. We suggest you change your account password.
                        </li>
                        @endif
                        @if($user->phone == '')
                        <li style="margin-top:10px;">
                            Please add a <b>Phone Number</b>(Required) to this account.
                        </li>
                        @endif
                    </ul>
                    <br>
                    <form method="POST" action="{{route('super_admin.quick-update')}}">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="ui action input">
                            @if($user->phone == '')
                            <input type="number" name="phone" required placeholder="Enter Phone Number...">
                            @endif
                            <input type="password" name="password" required placeholder="Enter New Password...">
                            <input type="password" name="password_confirmation" required placeholder="Confirm New Password...">
                            <button class="ui button teal">Update Details</button>
                        </div>
                    </form>
                    <br>
                    <div style="text-align:center;color:red;"><b>Notice:</b> Please update info within 5 login attempt, else your account might be inaccessible.</div>
                  </div>
                </div>
            </div>
        </div>
        @endif
    @endif
    @if(Auth::guard('admin')->check())
        @php $user = Auth::guard('admin')->user(); @endphp
    @endif
    @if(Auth::guard('teacher')->check())
        @php $user = Auth::guard('teacher')->user(); @endphp
    @endif
    @if(Auth::guard('student')->check())
        @php $user = Auth::guard('student')->user(); @endphp
    @endif
    <script>
        $(function(){
            if($('.updateNotifierModal').length > 0){
                var modal = $('.updateNotifierModal');
                modal.modal({
                    closable  : false,
                    centered: false,
                    position: 'top'
                }).modal('show');
            }
        });
    </script>
@endif