@extends('layouts.main')
@section('content')
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">
  @include('partial.error')
    <h2 class="ui orange image header">
      <img src="{{url_public('/images/header-logo.png')}}" class="image">
      <div class="content">
        Unity Examination Login
      </div>
    </h2>
    <form class="ui large form"  @if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.unity.login.card')))) action="{{route('exam.unity.login.card')}}" @else action="{{route('exam.unity.login.exam.number')}}" @endif method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
      <div class="ui stacked segment">
      @if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.unity.login.card'))))
        <input type="hidden" name="login_type" value="card">
        <input type="hidden" name="exam_type" value="unity_exam">
        <div class="field">
            <label>Serial Number</label>
            <input type="text" name="serial_no" value="{{old('serial_no')}}" placeholder="Enter Serial Number">
        </div>
        <div class="field">
            <label>PIN</label>
            <input type="password" name="pin" placeholder="Enter PIN" value="{{old('pin')}}">
        </div>
      @else
        <input type="hidden" name="login_type" value="regnum">
        <div class="field">
            <label>Examination Number</label>
            <input type="text" name="regnum" value="{{old('regnum')}}" placeholder="Enter Examination Number">
        </div>
        <div class="field">
            <label>Password</label>
            <input type="password" name="password" placeholder="Enter Password" value="{{old('password')}}">
        </div>
      @endif
        <button class="ui fluid large orange submit button" type="submit">Unity Examination Login</button>
      @if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.unity.login.card'))))
          <div class="ui message">
            <a href="{{route('exam.unity.login.exam.number')}}">Login with your Examination Number and Password</a>
          </div>
      @else
          <div class="ui message">
            <a href="{{route('exam.unity.login.card')}}"> Login with your Card PIN and Serial Number</a>
          </div>
      @endif
      </div>
    </form>
  </div>
</section>
@endsection