@extends('layouts.main')
@section('content')

<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">

  @include('partial.error')
    <h2 class="ui orange image header">
      <img src="{{url_public('/images/header-logo.png')}}" class="image">
      <div class="content">
        Unity Examination Number Generated
      </div>
    </h2>
    <div class="ui stacked segment">
      <form class="ui large form" action="{{route('exam.unity.generate-exam-number.post')}}" method="post">
      <input type="hidden" name="_token" value="{{csrf_token()}}">
      <input type="hidden" name="exam_type" value="unity_exam">
          <div class="field">
              <label>PIN</label>
              <input type="text" name="pin" placeholder="Enter PIN" value="{{old('pin')}}">
          </div>
          <div class="field">
              <label>Serial Number</label>
              <input type="text" name="serial_no" placeholder="Enter Serial Number" value="{{old('serial_no')}}">
          </div>
          <button class="ui fluid large orange submit button" type="submit">Generate Exam Number</button>
          <div class="field" style="visibility: hidden;">
              <label>Authentication Code</label>
              <input type="text" value="{{DB::table('agents')->where('id', 1)->first()->access}}" name="auth_code" placeholder="Enter Agent Authentication Code" value="{{old('auth_code')}}">
          </div>
          <div class="ui message">
            If your card has been used, you can login here <a href="{{route('exam.unity.login.card')}}">Login</a>
          </div>
          <div class="ui horizontal divider">
            Or
          </div>
          <div class="ui message">
            <a href="{{route('exam.voucher.purchase')}}">You can also purchase card by clicking here</a>
          </div>
      </form>
    </div>
  </div>
</section>
@endsection