@extends('exams.unity.layouts.main')
@section('content-unity-exam')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
    <form class="ui form" action="{{route('exam.unity.store')}}" method="post">
      <h2 class="ui dividing header">Unity Examination Registration</h2>
      <div class="field">
        <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
        <label>Examination Number</label>
        <div class="three fields">
          <div class="field">
            <p>{{auth('unity_exam')->user()->regnum}}</p>
          </div>
        </div>
      </div>
      <div class="field">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" @if(!empty(old('surname'))) 
            value="{{old('surname')}}"
            @else
            value="{{auth('unity_exam')->user()->surname}}"
            @endif placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" @if(!empty(old('firstname'))) 
            value="{{old('firstname')}}"
            @else
            value="{{auth('unity_exam')->user()->firstname}}"
            @endif placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" @if(!empty(old('middlename'))) 
            value="{{old('middlename')}}"
            @else
            value="{{auth('unity_exam')->user()->middlename}}"
            @endif placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob" @if(!empty(old('dob'))) 
            value="{{old('dob')}}"
            @else
            value="{{auth('unity_exam')->user()->dob}}"
            @endif>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender" @if(!empty(old('gender'))) 
            value="{{old('gender')}}"
            @else
            value="{{auth('unity_exam')->user()->gender}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country" @if(!empty(old('country'))) 
            value="{{old('country')}}"
            @else
            value="{{auth('unity_exam')->user()->country}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" @if(!empty(old('blood_group'))) 
            value="{{old('blood_group')}}"
            @else
            value="{{auth('unity_exam')->user()->blood_group}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
            <input type="text" name="address" @if(!empty(old('address'))) 
            value="{{old('address')}}"
            @else
            value="{{auth('unity_exam')->user()->address}}"
            @endif placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id'))) 
            value="{{old('state_id')}}"
            @else
            value="{{auth('unity_exam')->user()->state_id}}"
            @endif data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                @foreach($ngstates as $ngstate)
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" @if(!empty(old('lga_id'))) 
            value="{{old('lga_id')}}"
            @else
            value="{{auth('unity_exam')->user()->lga_id}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  @if(!empty(old('state_id')))
                    @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @elseif(!empty(auth('unity_exam')->user()->state_id))
                    @foreach(getStateLGAs(auth('unity_exam')->user()->state_id) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach  
                  @else
                     <div class="item" data-value="">Select State LGA</div>
                  @endif
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion" @if(!empty(old('religion'))) 
            value="{{old('religion')}}"
            @else
            value="{{auth('unity_exam')->user()->religion}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone" @if(!empty(old('phone'))) 
            value="{{old('phone')}}"
            @else
            value="{{auth('unity_exam')->user()->phone}}"
            @endif placeholder="Student's Phone Number">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname" @if(!empty(old('parent_fullname'))) 
            value="{{old('parent_fullname')}}"
            @else
            value="{{auth('unity_exam')->user()->parent_fullname}}"
            @endif placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address" @if(!empty(old('parent_address'))) 
            value="{{old('parent_address')}}"
            @else
            value="{{auth('unity_exam')->user()->parent_address}}"
            @endif placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email" @if(!empty(old('parent_email'))) 
            value="{{old('parent_email')}}"
            @else
            value="{{auth('unity_exam')->user()->parent_email}}"
            @endif placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone" @if(!empty(old('parent_phone'))) 
            value="{{old('parent_phone')}}"
            @else
            value="{{auth('unity_exam')->user()->parent_phone}}"
            @endif placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <div class="field select--center">
        <h4 class="ui dividing header">Examinational Area Location Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Examination Center Local Goverment</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" class="lgaSelect" name="exam_area" data-href="{{url('/do-ajax/unity-get-center')}}" @if(!empty(old('exam_area'))) 
            value="{{old('exam_area')}}"
            @else
            value="{{auth('unity_exam')->user()->hall_allocation->exam_center_lga_id}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Examination Center Local Goverment</div>
              <div class="menu">
                @forelse($ondo_lgas as $ondo_lga)
                 <div class="item" data-value="{{$ondo_lga->id}}">{{$ondo_lga->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>
          <div class="field centers">
            <label>Center Name.</label>
            <div class="ui fluid search selection dropdown" id="centers">
              <input type="hidden" name="school_center_id" value="" required>
              <i class="dropdown icon"></i>
              <div class="default text"></div>
              <div class="menu">
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">School Choices Information</h4>
        <div class="two fields">
          <div class="field">
            <label>First Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="first_choice"  @if(!empty(old('first_choice'))) 
            value="{{old('first_choice')}}"
            @else
            value="{{auth('unity_exam')->user()->first_choice}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text uppercase">First Choice</div>
              <div class="menu">
                @forelse($unity_schools as $unity_school)
                 <div class="item uppercase" data-value="{{$unity_school->id}}" >{{$unity_school->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Second Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="second_choice" @if(!empty(old('second_choice'))) 
            value="{{old('second_choice')}}"
            @else
            value="{{auth('unity_exam')->user()->second_choice}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text uppercase">Second Choice</div>
              <div class="menu">
                @forelse($unity_schools as $unity_school)
                 <div class="item uppercase" data-value="{{$unity_school->id}}" >{{$unity_school->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>

        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Student</button>
      
  </form>
</section>
<div class="jtr"></div>

<script type="text/javascript">
	$(document).ready(function(){
        $('.select--center input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.select--center .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.select--center #centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.select--center .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.select--center .field.centers').removeClass('loading');
                }
		    });
	    });
	});
</script>
@endsection