@extends('exams.unity.layouts.main')
@section('content-unity-exam')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
    <form class="ui form" action="{{route('exam.unity.confirm.post')}}" method="post">
      <h2 class="ui dividing header">Unity Examination Confirmation</h2>
      <div class="field">
        <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
        <label>Examination Number</label>
        <div class="three fields">
          <div class="field">
            <p>{{auth('unity_exam')->user()->regnum}}</p>
          </div>
        </div>
      </div>
      <div class="field">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <p>{{$student->surname}}</p>
          </div>
          <div class="field">
            <p>{{$student->firstname}}</p>
          </div>
          <div class="field">
            <p>{{$student->middlename}}</p>
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <p>{{\Carbon\Carbon::parse($student->dob)->format('jS F, Y ')}}</p>
          </div>
          <div class="field">
            <label>Gender</label>
            <p>{{$student->gender}}</p>
          </div>
          <div class="field">
            <label>Country</label>
            <p>{{$student->country}}</p>
          </div>
          <div class="field">
            <label>Blood Group</label>
            <p>{{$student->blood_group}}</p>
          </div>
      </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
          <p>{{$student->address}}</p>
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <p>{{$student->state->name}}</p>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <p>{{$student->statelga->name}}</p>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <p>{{$student->religion}}</p>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
            <p>{{$student->phone}}</p>
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
          <p>{{$student->parent_fullname}}</p>
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <p>{{$student->parent_address}}</p>
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
          <p>{{$student->parent_email}}</p>
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <p>{{$student->parent_phone}}</p>
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">Examinational Area Location Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Examination Center Local Goverment</label>
            <p>{{$student->hall_allocation()->with('ondo_lga')->first()->ondo_lga->name}}</p>
          </div>
          <div class="field">
            <label>Examination Center</label>
            <p style="text-transform: capitalize;">{{App\UnityCenter::find($student->hall_allocation()->first()->school_center_id)->name}}</p>
          </div>
        </div>
      </div>


      <div class="field">
        <h4 class="ui dividing header">School Choices Information</h4>
        <div class="two fields">
          <div class="field">
            <label>First Choice</label>
            <p>{{$student->first_choices->name}}</p>
          </div>
          

          <div class="field">
            <label>Second Choice</label>
            <p>{{$student->second_choices->name}}</p>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Student Passport</label>
           <div class="ui medium image">
            <img src="{{url_public($student->passport)}}">
          </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="three fields">
          <div class="field">
            <a href="{{route('exam.unity.create')}}" class="fluid ui button teal">Update Student Information</a>
          </div>
          <div class="field">
            <a href="{{route('exam.unity.passport')}}" class="fluid ui button teal">Update Passpost</a>
          </div>
          <div class="field">
            <button class="fluid ui button" type="submit" onclick="confirm('Are you sure you want to submit the form, Once submitted you cannot modify the Bio Data?')" style="background-color: #f75a0c; color:white;">Final Submission</button>
          </div>
      </div>
      </div>
      
  </form>
</section>
<div class="jtr"></div>
@endsection