@extends('layouts.main')
@section('content')
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">
  @include('partial.error')
    <h2 class="ui orange image header">
      <img src="{{url_public('/images/header-logo.png')}}" class="image">
      <div class="content">
        Purchase Examination Voucher Online
      </div>
    </h2>
    <form class="ui large form"  method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
      <div class="ui stacked segment">
        <div class="field">
            <label>Fullname</label>
            <input type="text" name="fullname" value="{{old('fullname')}}" placeholder="Enter Fullname">
        </div>
        <div class="field">
            <label>Email <br><span style="color:red">(This is the email that voucher will be sent)</span></label>
            <input type="email" name="email" placeholder="Enter Email" value="{{old('email')}}">
        </div>
        <div class="field">
            <label>Phone Number <br><span style="color:red">(This is the phone number that voucher will be sent)</span></label>
            <input type="number" name="phone" placeholder="Enter Phone Number" value="{{old('phone')}}">
        </div>
        <div class="field">
            <label>Voucher Slot</label>
            <input type="number" name="slot" placeholder="Enter Number of Slot" value="{{old('slot')}}">
        </div>
        <div class="field">
            <label>Exam Type</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="exam_type" value="{{old('exam_type')}}" >
              <i class="dropdown icon"></i>
              <div class="default text">Exam Type</div>
              <div class="menu">
                 <div class="item" data-value="unity_exam">Unity Examination</div>
                 <div class="item" data-value="entrance">Common Entrance Exam</div>
              </div>
            </div>
        </div>
        <button class="ui fluid large orange submit button" type="submit">Purchase Exam Voucher Online</button>
	      <div class="ui message">
	        <a href="{{route('exam.unity.login.card')}}"> Login with your Card PIN and Serial Number</a>
	      </div>
      </div>
    </form>
  </div>
</section>
@endsection