@extends('exams.entrance.layouts.main')
@section('content-entrance-exam')
<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
	<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	S/N
		    </th>
		    <th>
		    	Student's Fullname
		    </th>
		    <th>
		    	Registration Number
		    </th>
		    <th>
		    	Passport
		    </th>
			<th colspan="2">
		    	Actions
		    </th>
		    <th >
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr>
		  </thead>
		  <tbody>
		  	<form class="ui form" action="{{route('super_admin.generate.student-school-id-card')}}" method="post">
			 @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $students->perPage() @endphp
		  	@forelse($students as $student)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</td>
		      <td>{{$student->regnum}}</td>
		      <td>
		      	<img class="ui image small" @if($student->passport !== NULL) src="{{url_public($student->passport)}}" @else src="{{url_public('/images/passports/no_img_da88a72526.gif')}}"  @endif >
		      </td>
		      <td class="std-view">
		      	@if($student->submitted == 1)
			      <button type="button" class="ui labeled blue icon button" data-std-id="{{$student->id}}" data-href="{{route('exam.entrance.edit.student', ['id' => $student->id])}}">
				  <i class="edit icon"></i>
				  Update Bio Data/Passport
				</button>
				@else
					<p>You have not Complete Registration</p>
				@endif
			  </td>
			  <td class="std-view">
			  	@if($student->submitted == 0)
					<button type="button" class="ui labeled blue icon button" data-std-id="{{$student->id}}" data-href="{{route('exam.entrance.edit.student', ['id' => $student->id])}}">
				  <i class="edit icon"></i>
				  Continue Registration
				</button>
			  	@else
			      <button type="button" class="ui labeled orange icon button" data-std-id="{{$student->id}}" data-href="{{route('exam.entrance.photocard-id', ['id' => $student->id])}}">
				  <i class="edit icon"></i>
				  View Photo Card
				</button>
			  	@endif
			  </td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_id[]" value="{{$student->id}}" @if(!empty(old('student_id'))){{in_array($student->id, old('student_id')) ? 'checked="checked"' : ''}}@endif><label></label>
				</div>
			  </td>
		    </tr>
		    
		   @empty
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endforelse
		  @if($students->count() > 0)
		  <tr>
		    	<td colspan="7">
		    		<!-- <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;padding: 10px !important;">Generate Student ID Card</button> -->
		    	</td>
		    </tr>

		  @endif
		  </form>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="7">
		     @include('pagination.default', ['paginator' => $students])
		    </th>
		  </tr></tfoot>
		</table>
</section>
@endsection