@extends('layouts.main')
@section('content')
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">
  @include('partial.error')
    <h2 class="ui orange image header">
      <img src="{{url_public('/images/header-logo.png')}}" class="image">
      <div class="content">
        Common Entrance Examination Login
      </div>
    </h2>
    <form class="ui large form"  @if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.entrance.login.card')))) action="{{route('exam.entrance.login.card')}}" @else action="{{route('exam.entrance.login.exam.number')}}" @endif method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
      <div class="ui stacked segment">
      @if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.entrance.login.card'))))
        <input type="hidden" name="login_type" value="card">
        <input type="hidden" name="exam_type" value="entrance_exam">
        <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/primary-school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate->ondo_lga as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="{{old('school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                @if(!empty(old('school')))
                    @foreach(getSchools(old('school')) as $school)
                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Schools</div>
                  @endif
              </div>
            </div>
          </div> 
        <div class="field">
            <label>Serial Number</label>
            <input type="text" name="serial_no" value="{{old('serial_no')}}" placeholder="Enter Serial Number">
        </div>
        <div class="field">
            <label>PIN</label>
            <input type="password" name="pin" placeholder="Enter PIN" value="{{old('pin')}}">
        </div>
      @else
        <input type="hidden" name="login_type" value="email">
        <div class="field">
            <label>School Email Address</label>
            <input type="text" name="email" value="{{old('email')}}" placeholder="Enter Examination Number">
        </div>
        <div class="field">
            <label>Password</label>
            <input type="password" name="password" placeholder="Enter Password" value="{{old('password')}}">
        </div>
      @endif
        <button class="ui fluid large orange submit button" type="submit">Common Entrance Examination Login</button>
      @if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.entrance.login.card'))))
          <div class="ui message">
            <a href="{{route('exam.entrance.login.exam.number')}}">Login with your Examination Number and Password</a>
          </div>
      @else
          <div class="ui message">
            <a href="{{route('exam.entrance.login.card')}}"> Login with your Card PIN and Serial Number</a>
          </div>
      @endif
      </div>
    </form>
  </div>
</section>
@endsection