@extends('layouts.main')
@section('content')

<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">

  @include('partial.error')
    <h2 class="ui orange image header">
      <img src="{{url_public('/images/header-logo.png')}}" class="image">
      <div class="content">
        Common Entrance Examination Number Generated
      </div>
    </h2>
    <div class="ui stacked segment">
      <form class="ui large form" action="{{route('exam.entrance.generate-exam-number.post')}}" method="post">
      <input type="hidden" name="_token" value="{{csrf_token()}}">
      <input type="hidden" name="exam_type" value="entrance">
          <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/primary-school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate->ondo_lga as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="{{old('school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                @if(!empty(old('school')))
                    @foreach(getSchools(old('school')) as $school)
                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Schools</div>
                  @endif
              </div>
            </div>
          </div> 
          <div class="field">
              <label>PIN</label>
              <input type="text" name="pin" placeholder="Enter PIN" value="{{old('pin')}}">
          </div>
          <div class="field">
              <label>Serial Number</label>
              <input type="text" name="serial_no" placeholder="Enter Serial Number" value="{{old('serial_no')}}">
          </div>
          <div class="field">
              <label>Authentication Code</label>
              <input type="text" name="auth_code" placeholder="Enter Agent Authentication Code" value="{{old('auth_code')}}">
          </div>
          <button class="ui fluid large orange submit button" type="submit">SUBMIT</button>
          <div class="ui message">
            If your card has been used, you can login here <a href="{{route('exam.entrance.login.card')}}">Login</a>
          </div>
          <div class="ui horizontal divider">
            Or
          </div>
          <div class="ui message">
            <a href="{{route('exam.voucher.purchase')}}">You can also purchase card by clicking here</a>
          </div>
      </form>
    </div>
  </div>
</section>
@endsection