@extends('layouts.main')
@section('content')
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">

  @include('partial.error')
    <h2 class="ui orange image header">
      <img src="{{url_public('/images/header-logo.png')}}" class="image">
      <div class="content">
        Common Entrance Examination Password
      </div>
    </h2>
    <form class="ui large form" action="{{route('exam.entrance.generate-candidate-password')}}" method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
    <input type="hidden" name="school" value="{{$school->id}}">
    <input type="hidden" name="auth_code" value="{{$auth_code}}">
      <div class="ui stacked segment">
        <div class="field">
            <label>Registration Number</label>
            <p>{{$school->name}}</p>
        </div>
        <div class="field">
            <label>Email</label>
            <input type="email" name="email" placeholder="Email Address" value="{{old('email')}}">
        </div>
        <div class="field">
            <label>Password</label>
            <input type="password" name="password" placeholder="Password" value="">
        </div>
        <div class="field">
            <label>Password Confirmation</label>
            <input type="password" name="password_confirmation" placeholder="Password Confirmation" value="">
        </div>
        <button class="ui fluid large orange submit button" type="submit">Generate School Email and Password</button>
      </div>


    </form>
  </div>
</section>
@endsection