@extends('exams.entrance.layouts.main')
@section('content-entrance-exam')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
    <form class="ui form" action="" method="post">
    {{csrf_field()}}
      <h2 class="ui dividing header">Common Entrance Examination Registration</h2>
      <div class="field">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" @if(!empty(old('surname'))) value="{{old('surname')}}" @else value="{{$student->surname}}" @endif placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" @if(!empty(old('firstname'))) value="{{old('firstname')}}"  @else value="{{$student->firstname}}" @endif placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename"  @if(!empty(old('middlename'))) value="{{old('middlename')}}"  @else value="{{$student->middlename}}" @endif placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob"  @if(!empty(old('dob'))) value="{{old('dob')}}"  @else value="{{$student->dob}}" @endif>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"  @if(!empty(old('gender'))) value="{{old('gender')}}"  @else value="{{$student->gender}}" @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country"  @if(!empty(old('country'))) value="{{old('country')}}"  @else value="{{$student->country}}" @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" @if(!empty(old('blood_group'))) value="{{old('blood_group')}}"  @else value="{{$student->blood_group}}" @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
            <input type="text" name="address"  @if(!empty(old('address'))) value="{{old('address')}}"  @else value="{{$student->address}}" @endif placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id"  @if(!empty(old('state_id'))) value="{{old('state_id')}}"  @else value="{{$student->state_id}}" @endif data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                @foreach($ngstates as $ngstate)
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id"  @if(!empty(old('lga_id'))) value="{{old('lga_id')}}"  @else value="{{$student->lga_id}}" @endif>
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  @if(!empty(old('state_id')))
                    @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @elseif(!empty($student->state_id))
                    @foreach(getStateLGAs($student->state_id) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @endif
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion"  @if(!empty(old('religion'))) value="{{old('religion')}}"  @else value="{{$student->religion}}" @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone"  @if(!empty(old('phone'))) value="{{old('phone')}}"  @else value="{{$student->phone}}" @endif placeholder="Student's Phone Number">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname"  @if(!empty(old('parent_fullname'))) value="{{old('parent_fullname')}}"  @else value="{{$student->parent_fullname}}" @endif placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address"  @if(!empty(old('parent_address'))) value="{{old('parent_address')}}"  @else value="{{$student->parent_address}}" @endif placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email"   @if(!empty(old('parent_email'))) value="{{old('parent_email')}}"  @else value="{{$student->parent_email}}" @endif placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone"  @if(!empty(old('parent_phone'))) value="{{old('parent_phone')}}"  @else value="{{$student->parent_phone}}" @endif placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <!-- <div class="field">
        <h4 class="ui dividing header">Examinational Area Location Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Examination Center Local Goverment</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="exam_area""   @if(!empty(old('exam_area'))) value="{{old('exam_area')}}"  @else value="{{$student->hall_allocation->exam_center_lga_id}}" @endif >
              <i class="dropdown icon"></i>
              <div class="default text">Examination Center Local Goverment</div>
              <div class="menu">
                @forelse($ondo_lgas as $ondo_lga)
                 <div class="item" data-value="{{$ondo_lga->id}}">{{$ondo_lga->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>

        </div>
      </div> -->

      <div class="field">
        <h4 class="ui dividing header">School Choices Information</h4>
        <div class="two fields">
          <div class="field">
            <label>First Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="first_choice" @if(!empty(old('first_choice'))) value="{{old('first_choice')}}"  @else value="{{$student->first_choice}}" @endif>
              <i class="dropdown icon"></i>
              <div class="default text uppercase">First Choice</div>
              <div class="menu">
                @forelse($entrance_schools as $entrance_school)
                 <div class="item uppercase" data-value="{{$entrance_school->id}}" >{{$entrance_school->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Second Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="second_choice" @if(!empty(old('second_choice'))) value="{{old('second_choice')}}"  @else value="{{$student->second_choice}}" @endif">
              <i class="dropdown icon"></i>
              <div class="default text uppercase">Second Choice</div>
              <div class="menu">
                @forelse($entrance_schools as $entrance_school)
                 <div class="item uppercase" data-value="{{$entrance_school->id}}" >{{$entrance_school->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>

        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Update Student Bio Data</button>
      
  </form>
</section>
<div class="jtr"></div>
@endsection