@extends('exams.entrance.layouts.main')
@section('content-entrance-exam')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
    <form class="ui form" action="{{route('exam.entrance.store')}}" method="post">
    {{csrf_field()}}
      <h2 class="ui dividing header">Common Entrance Examination Registration</h2>
      <div class="field">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname"  value="{{old('surname')}}" placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname"  value="{{old('firstname')}}" placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename"  value="{{old('middlename')}}" placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob"  value="{{old('dob')}}">
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"  value="{{old('gender')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country"  value="{{old('country')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group"  value="{{old('blood_group')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
            <input type="text" name="address"  value="{{old('address')}}" placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id"  value="{{old('state_id')}}" data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                @foreach($ngstates as $ngstate)
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id"  value="{{old('lga_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  @if(!empty(old('state_id')))
                    @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Select State LGA</div>
                  @endif
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion"  value="{{old('religion')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone"  value="{{old('phone')}}" placeholder="Student's Phone Number">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname"  value="{{old('parent_fullname')}}" placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address"  value="{{old('parent_address')}}" placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email"  value="{{old('parent_email')}}" placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone"  value="{{old('parent_phone')}}" placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <!-- <div class="field">
        <h4 class="ui dividing header">Examinational Area Location Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Examination Center Local Goverment</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="exam_area""  value="{{old('exam_area')}}" >
              <i class="dropdown icon"></i>
              <div class="default text">Examination Center Local Goverment</div>
              <div class="menu">
                @forelse($ondo_lgas as $ondo_lga)
                 <div class="item" data-value="{{$ondo_lga->id}}">{{$ondo_lga->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>

        </div>
      </div> -->

      <div class="field">
        <h4 class="ui dividing header">School Choices Information</h4>
        <div class="two fields">
          <div class="field">
            <label>First Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="first_choice" value="{{old('first_choice')}}">
              <i class="dropdown icon"></i>
              <div class="default text uppercase">First Choice</div>
              <div class="menu">
                @forelse($entrance_schools as $entrance_school)
                 <div class="item uppercase" data-value="{{$entrance_school->id}}" >{{$entrance_school->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Second Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="second_choice" value="{{old('second_choice')}}">
              <i class="dropdown icon"></i>
              <div class="default text uppercase">Second Choice</div>
              <div class="menu">
                @forelse($entrance_schools as $entrance_school)
                 <div class="item uppercase" data-value="{{$entrance_school->id}}" >{{$entrance_school->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>

        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Student</button>
      
  </form>
</section>
<div class="jtr"></div>
@endsection