@extends('layouts.main')

<!-- Main Content -->
@section('content')
<section class="ui raised segment" style="max-width: 600px; margin: 20px auto;">
@include('partial.error')
@if (session('status'))
    <div class="ui positive floated message">
        {{ session('status') }}
    </div>
@endif
    <form class="ui form" action="{{route('teacher.send.password')}}" method="post">
    <h4 class="ui dividing header">Teacher Reset Password</h4>
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
      <div class="field">
        <label>Email</label>
        <div class="ui right labeled left icon input">
        <i class="mail icon"></i>
          <input type="email" name="email" value="{{old('email')}}" placeholder="Enter your email">
          <a class="ui tag label">
            Add Email
          </a>
        </div>
      </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Send Password Reset Link</button>
      </div>
    </form>

    <div class="ui message">
      Oh I remember my password ? <a href="{{route('teacher.login')}}">Back to Login Page</a>
    </div>
</section>
<div class="jtr"></div>
@endsection
