@extends('layouts.main')
@section('content')
<style>
    .student_reciept{
        background-size: contain !important;
        background-repeat: no-repeat !important;
        background-position-x: 647px !important;
    }
    @print{
        .print-none{
            display: none !important;
        }
    }
</style>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;box-shadow: 0px 0px 0px transparent !important;border-style: none !important;">
	@forelse($reciepts as $reciept)
	@php
	    $student_current_class = DB::table('classarm_student')
                                ->where('student_id', $reciept->id)
                                ->orderBy('session', 'desc')
                                ->first();
        $student_voucher = App\ResultVoucher::where('student_id', '=', $reciept->id)
            ->where('session', '=', $student_current_class->session)
            ->where('class_id', '=', $student_current_class->class_id)
            ->where('classarm_id', '=', $student_current_class->classarm_id)
            ->get()->first();
        $payment = App\DigitalPayment::where('student_id', $reciept->id)->get()->first();
	@endphp
	<div class="ui segment student_reciept" style="background: url('{{url_public('/images/header-logo.png')}}')">
        <div class="ui divided items">
          <div class="item">
            <div class="image">
              <img src="{{url_public($reciept->passport)}}">
            </div>
            <div class="content">
              <a class="header">{{$reciept->surname}} {{$reciept->firstname}} {{$reciept->middlename}}</a>
              <div class="meta">
                <span class="cinema">#Digital Payment</span>
              </div>
              <div class="description">
                  @php error_reporting(0); @endphp
                <p><strong>OSSI Number:</strong> <span>{{$reciept->regnum}}</span></p>
                <p><strong>Pin:</strong> <span>{{$student_voucher->pin}}</span></p>
                <p><strong>Serial:</strong> <span>{{$student_voucher->serial}}</span></p>
                <p><strong>Session:</strong> <span>{{$student_voucher->session}}</span></p>
                <p><strong>Status:</strong> <span style="color:green;">Paid</span></p>
                <p><strong>Amount:</strong> <span>₦{{DB::table('payment_items')->first()->cost + 200}}</span></p>
              </div>
              <div class="extra">
                  <small>Reciept was generated {{$payment->created_at->diffForHumans()}}</small>
              </div>
            </div>
          </div>
        </div>
    </div>
	@empty
	<div class="ui icon negative message">
	  <i class="info circle icon"></i>
	  <div class="content">
	    <div class="header">
	    Sorry, No Reciept found.
	  	</div>
	  </div>
	</div>
	@endforelse
	<div class="ui primary button printnone" onclick="printDiv()">
      Print Reciepts
      <i class="print icon"></i>
    </div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
<script>
function printDiv() 
{
    print();
}
</script>
@endsection