@extends('layouts.main')
@section('content')
<br>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
	<h2 class="ui horizontal divider cap header" style="color:#dc4900;">
	  My Wallet
	</h2>
	<div class="ui statistics">
	  <div class="statistic">
	    <div class="value">
	      ₦{{money_format('%i', $wallet->available_balance)}}
	    </div>
	    <div class="label">
	      Available Balance
	    </div>
	  </div>
	  <div class="statistic">
	    <div class="value">
	      ₦{{money_format('%i', $wallet->last_payment)}}
	    </div>
	    <div class="label">
	      Last Payment
	    </div>
	  </div>
	</div>
	<br>
	<!-- ui stackable equal height stackable grid -->
	<div class="grid">
		<div class="shadowundertop"></div>
		<div class="row">
			<div class="c8">
                <div class="ui grid">
                    <div class="four wide column">
                        <div class="ui vertical fluid tabular menu">
                        <a href="{{url('admin/school-wallet')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                            Transactions
                        </a>
                        <a href="{{url('admin/school-wallet?action=verify_payment')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'verify_payment') active @endif">
                            Verify Payment
                        </a>
                        <a href="{{url('admin/school-wallet?action=reciept_print')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'reciept_print') active @endif">
                            Reciept Print
                        </a>
                        </div>
                    </div>
                    <div class="twelve wide stretched column">
                        <div class="ui segment">
                            @if(isset($_GET['action']) && $_GET['action'] == 'verify_payment')
                            <div class="form-group">
                                <label class="col-md-3 control-label">Payment For</label>
                                <div class="col-md-5">
                                    <div class="field">
                                        <select name="item_id" required class="ui fluid search dropdown">
                                            <option value="Digital Payment">Digital Payment</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <form class="ui form" action="{{route('admin.school.wallet.student.search')}}" onsubmit="event.preventDefault(); searchStudents(this);" method="post" enctype="multipart/form-data">
                    			<input type="hidden" name="_token" value="{{csrf_token()}}">
                    		  <h2 class="ui dividing header">Search Students</h2>
                    		  <div class="five fields">
                    	      <div class="field">
                    	        <label>Session</label>
                    	        <div class="ui fluid search selection dropdown">
                    	          <input type="hidden" name="session" value="{{old('session')}}" required>
                    	          <i class="dropdown icon"></i>
                    	          <div class="default text">Session</div>
                    	          <div class="menu">
                    	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                    	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                    	            @endfor
                    	          </div>
                    	        </div>
                    	      </div>
                    	      <div class="field">
                    	        <label>Term</label>
                    	        <div class="ui fluid search selection dropdown">
                    	          <input type="hidden" name="term" value="{{old('term')}}" required>
                    	          <i class="dropdown icon"></i>
                    	          <div class="default text">Term</div>
                    	          <div class="menu">
                    	             <div class="item" data-value="First"> First Term </div>
                    	             <div class="item" data-value="Second"> Second Term </div>
                    	             <div class="item" data-value="Third"> Third Term </div>
                    	          </div>
                    	        </div>
                    	      </div>
                    	      
                    	      <div class="field">
                    	        <label>Class</label>
                    	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
                    	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" required>
                    	          <i class="dropdown icon"></i>
                    	          <div class="default text">Class</div>
                    	          <div class="menu">
                    	            @foreach($classes as $class)
                    	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                    	            @endforeach
                    	          </div>
                    	        </div>
                    	      </div>
                    	      <div class="field" id="field-arms">
                    	        <label>Class Arm</label>
                    	        <div class="ui fluid search selection dropdown">
                    	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}" required>
                    	          <i class="dropdown icon"></i>
                    	          <div class="default text">Class Arm</div>
                    	          <div class="menu" id="class-arms">
                    	            @if(!empty(old('class_id')))
                    	                @foreach(getClassArms(old('class_id')) as $class_arm)
                    	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                    	                @endforeach
                    	              @else
                    	                 <div class="item" data-value="">Select Class Arm</div>
                    	              @endif
                    	            
                    	          </div>
                    	        </div>
                    	      </div>
                    	      <div class="field">
                    	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
                    	      </div>
                    
                    	    </div>
                    		  
                    		</form>
                            <br>
                            <form method="post" action="" class="form-horizontal global_form">
                                {{csrf_field()}}
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                <input type="hidden" name="payer_id" value="{{auth('admin')->user()->id}}">
                                <div class="form-group">
                                    <div class="col-md-9">
                                        <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                            <table class="ui compact celled definition table">
                                                <thead>
                                                    <tr>
                                                    <th></th>
                                                    <th>Full Name</th>
                                                    <th>Registration Number</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="studentsTable">
                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                
                                <br>
                                <br>
                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="submit" class="ui small blue button" name="form_submit" value="Verify Students" />
                                    </div>
                                </div>
                            </form>
                            @elseif(isset($_GET['action']) && $_GET['action'] == 'reciept_print')
                            <div class="new">
                                <form method="POST" action="{{route('admin.school.wallet.student.reciept.search')}}" class="form form-horizontal global_form">
            					    <input type="hidden" name="_token" value="{{csrf_token()}}">
                                    <input type="hidden" name="type" value="single">
            						<div class="ui left action input fluid">
            							<button class="ui orange labeled icon button">
            									<i class="search icon"></i>
            									Search student by OSSI Number
            							</button>
            							<input type="search" placeholder="Enter OSSI Number..." name="student_number" required />
            						</div>
            					</form>
            					<div class="new_result" id="DivIdToPrint">
            					    @if(session()->has('studentReciept'))
            					        @php $studentReciept = session('studentReciept'); @endphp
            					        <div class="ui segment">
            					            <div class="ui divided items">
                                              <div class="item">
                                                <div class="image">
                                                  <img src="{{url_public($studentReciept->passport)}}">
                                                </div>
                                                <div class="content">
                                                  <a class="header">{{$studentReciept->surname}} {{$studentReciept->firstname}} {{$studentReciept->middlename}}</a>
                                                  <div class="meta">
                                                    <span class="cinema">{{$studentReciept->regnum}}</span>
                                                  </div>
                                                  <div class="description">
                                                    <p></p>
                                                  </div>
                                                  <div class="extra">
                                                    <div class="ui right floated primary button" onclick="printDiv()">
                                                      Print Reciept
                                                      <i class="print icon"></i>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
            					        </div>
            					    @endif
            					</div>
            					<br>
            					<span>Or</span>
                                <form class="ui form" action="{{route('admin.school.wallet.student.search')}}" onsubmit="event.preventDefault(); searchStudents(this);" method="post" enctype="multipart/form-data">
                        			<input type="hidden" name="_token" value="{{csrf_token()}}">
                        		  <h2 class="ui dividing header">Search Multiple Students</h2>
                        		  <div class="five fields">
                        	      <div class="field">
                        	        <label>Session</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="session" value="{{old('session')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Session</div>
                        	          <div class="menu">
                        	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                        	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                        	            @endfor
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	        <label>Term</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="term" value="{{old('term')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Term</div>
                        	          <div class="menu">
                        	             <div class="item" data-value="First"> First Term </div>
                        	             <div class="item" data-value="Second"> Second Term </div>
                        	             <div class="item" data-value="Third"> Third Term </div>
                        	          </div>
                        	        </div>
                        	      </div>
                        	      
                        	      <div class="field">
                        	        <label>Class</label>
                        	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
                        	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Class</div>
                        	          <div class="menu">
                        	            @foreach($classes as $class)
                        	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                        	            @endforeach
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field" id="field-arms">
                        	        <label>Class Arm</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Class Arm</div>
                        	          <div class="menu" id="class-arms">
                        	            @if(!empty(old('class_id')))
                        	                @foreach(getClassArms(old('class_id')) as $class_arm)
                        	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                        	                @endforeach
                        	              @else
                        	                 <div class="item" data-value="">Select Class Arm</div>
                        	              @endif
                        	            
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
                        	      </div>
                        
                        	    </div>
                        		  
                        		</form>
                                <br>
                                <form method="post" action="{{route('admin.school.wallet.student.reciept.search')}}" class="form-horizontal global_form">
                                    {{csrf_field()}}
                                    <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                    <input type="hidden" name="payer_id" value="{{auth('admin')->user()->id}}">
                                    <input type="hidden" name="type" value="multiple">
                                    <div class="form-group">
                                        <div class="col-md-9">
                                            <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                                <table class="ui compact celled definition table">
                                                    <thead>
                                                        <tr>
                                                        <th></th>
                                                        <th>Full Name</th>
                                                        <th>Registration Number</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="studentsTable">
                                                        
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    
                                    <br>
                                    <br>
                                    <div class="form-group text-center m-t-30">
                                        <div class="col-md-4 col-xs-offset-4">
                                            <input type="submit" class="ui small blue button" name="form_submit" value="Verify Students" />
                                        </div>
                                    </div>
                                </form>
                                </div>
                            @else
                            	@php $transactions = App\Transaction::where('school_id', $school->id)->paginate(20) @endphp
	                            <div class="ui feed">
	                            @forelse($transactions as $transaction)
								  <div class="event">
								    <div class="label">
								      <img src="{{url_public($school->logo)}}">
								    </div>
								    <div class="content">
								      <div class="summary">
								        {{$transaction->title}}
								      </div>
								      <div class="date">
								        <small>{{$transaction->created_at->diffForHumans()}}</small>
								      </div>
								      <div class="extra text">
								        {{$transaction->description}}
								      </div>
								    </div>
								  </div>
								@empty
									<div class="ui icon negative message">
									  <i class="info circle icon"></i>
									  <div class="content">
									    <div class="header">
									    Sorry, No Record can be found.
									  	</div>
									  </div>
									</div>
								@endforelse
								</div>
								@if($transactions->count() > 0)
                                @include('pagination.default', ['paginator' => $transactions])
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
			</div>
		</div>	
	</div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
<script>
$(document).ready(function(){
    
});
function searchStudents(obj){
    var form,table,data,route;
    form = $(obj);
    table = $('#studentsTable');
    $('.multiple_select_holder .field.loading').remove();
    $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

    // throw ajax
    // var token = "{{csrf_token()}}";
    route = form.attr('action');
    data = form.serialize();
    $.ajax({
        url: route,
        type: 'POST',
        data: data,
        success: function(response){
            console.log(response);
            table.html('')
            $.each(response,  function(index, value){
                $item = '<tr>';
                $item += '<td class="collapsing">';
                $item += '<div class="ui fitted slider checkbox">';
                $item += '<input type="checkbox"  name="student_id[]" value="'+value.id+'"> <label></label>';
                $item += '</div>';
                $item += '</td>';
                $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                $item += '<td>'+value.regnum+'</td>';
                $item += '</tr>';

                table.append($item);
            });
            $('.multiple_select_holder .field.loading').remove();
        },
        error: function(error){
            console.error(error);
            table.html('');
            $('.multiple_select_holder .field.loading').remove();
        }
    });
}
function printDiv() 
{

  var divToPrint=document.getElementById('DivIdToPrint');

  var newWin=window.open('','Print-Window');

  newWin.document.open();

  newWin.document.write('<html><body onload="window.print()">'+divToPrint.innerHTML+'</body></html>');

  newWin.document.close();

  setTimeout(function(){newWin.close();},10);

}
</script>
@endsection