@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="{{route('user.view.school.users.post')}}" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search User</h2>
		  <div class="two fields">

	      <div class="field">
	        <label>Users</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="id" value="{{old('id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Users</div>
	          <div class="menu">
	          @foreach($all_admin as $admin)
				<div class="item" data-value="{{$admin->id}}">{{$admin->fullname}}</div>
	          @endforeach
	          </div>
	        </div>
	      </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Admin</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View School Admin Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">User's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">User's Username</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">User's Permissions</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Users</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($admins) > 0)
		  @php $counter = 0 @endphp
		  	@foreach($admins as $admin)
		    <tr>
		      <td style="vertical-align: top;">{{++$counter}}</td>
		      <td valign="top">{{$admin->fullname}}</td>
		      <td valign="top">{{$admin->username}}</td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	@foreach(getAdminAssocPermissions($admin->id) as $a_p)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$a_p->permission}}</p>
				    </div>
				</div>
		      	@endforeach
		      	</div>
		      </td>
		      <td class="std-view" valign="top">
		      @if(auth('admin')->user()->can('edit-user'))
			      <button class="ui labeled blue icon button" data-std-id="{{$admin->id}}" data-href="{{route('admin.edit.school.user', ['id' => $admin->id])}}">
				  <i class="edit icon"></i>
				  Edit
				</button>
			@endif
			  </td>
		      <td class="std-view" valign="top">
		      @if(auth('admin')->user()->can('delete-user'))
				<button class="ui labeled negative icon button" data-std-id="{{$admin->id}}" data-href="{{route('admin.delete.school.user', ['id' => $admin->id])}}">
				  <i class="trash icon"></i>
				  Delete
				</button>
			 @endif
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      @include('pagination.default', ['paginator' => $admins])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection