@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Edit School Admin</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    <input type="hidden" value="put" name="_method">
    <label>Fullname</label>
        <input type="text" name="fullname" @if(!empty(old('fullname')))
          value="{{old('fullname')}}"
        @else
          value="{{$admin->fullname}}"
        @endif placeholder="Fullname">
  </div>

  <div class="field">
    <label>Username</label>
    <input type="text" name="username"  @if(!empty(old('username')))
          value="{{old('username')}}"
        @else
          value="{{$admin->username}}"
        @endif placeholder="Username">
  </div>
  <div class="field">
    <label>Email</label>
    <input type="email" name="email"  @if(!empty(old('email')))
          value="{{old('email')}}"
        @else
          value="{{$admin->email}}"
        @endif placeholder="Email Address">
  </div>
  <div class="field">
    <label>Phone</label>
    <input type="text" name="phone" @if(!empty(old('phone')))
          value="{{old('phone')}}"
        @else
          value="{{$admin->phone}}"
        @endif placeholder="Phone Formart: 2348022222222">
  </div>
  <div class="field">
    <label>Password</label>
    <input type="password" name="password" placeholder="Password">
  </div>
  <div class="field">
    <label>Confirm Password</label>
    <input type="password" name="password_confirmation" placeholder="Confirm Password">
  </div>
  <div class="field">
    <div class="ui toggle checkbox">
		<input type="checkbox" name="status"   @if(!empty(old('email')))
            {{(int)old('status') == 1 ? 'checked="checked"' : ''}}
     @else
            {{(int)$admin->status == 1 ? 'checked="checked"' : ''}}
      @endif value="1"><label>Account Status</label>
	</div>
  </div>

<div class="field">
   <h4 class="ui dividing header">Permissions</h4>
    <div class="three fields">
      <div class="field">
        <label>Student Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
              @if(!empty(old('permissions')) )
                 @foreach($student_permission as $s_p)
                  <option  value="{{$s_p->id}}" 
                  @if(in_array($s_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$s_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($student_permission as $s_p)
                  <option  value="{{$s_p->id}}" 
                  @if(in_array($s_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$s_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
      <div class="field">
        <label>Teacher Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($teacher_permission as $t_p)
                  <option  value="{{$t_p->id}}" 
                  @if(in_array($t_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$t_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($teacher_permission as $t_p)
                  <option  value="{{$t_p->id}}" 
                  @if(in_array($t_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$t_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
      <div class="field">
        <label>Class Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($class_permission as $c_p)
                  <option  value="{{$c_p->id}}" 
                  @if(in_array($c_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$c_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($class_permission as $c_p)
                  <option  value="{{$c_p->id}}" 
                  @if(in_array($c_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$c_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
  	</div>
  	<div class="three fields">
      <div class="field">
        <label>Classarm Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($classarm_permission as $c_p)
                  <option  value="{{$c_p->id}}" 
                  @if(in_array($c_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$c_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($classarm_permission as $c_p)
                  <option  value="{{$c_p->id}}" 
                  @if(in_array($c_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$c_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
      <div class="field">
        <label>Assignment Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($assignment_permission as $a_p)
                  <option  value="{{$a_p->id}}" 
                  @if(in_array($a_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$a_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($assignment_permission as $a_p)
                  <option  value="{{$a_p->id}}" 
                  @if(in_array($a_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$a_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
      <div class="field">
        <label>Subject Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($subject_permission as $s_p)
                  <option  value="{{$s_p->id}}" 
                  @if(in_array($s_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$s_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($subject_permission as $s_p)
                  <option  value="{{$s_p->id}}" 
                  @if(in_array($s_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$s_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
  	</div>
  	<div class="three fields">
      <div class="field">
        <label>User Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($user_permission as $u_p)
                  <option  value="{{$u_p->id}}" 
                  @if(in_array($u_p->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$u_p->permission}}</option>
                 @endforeach
              @else
                  @foreach($user_permission as $u_p)
                  <option  value="{{$u_p->id}}" 
                  @if(in_array($u_p->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$u_p->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>

      <div class="field">
        <label>Result Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($result_permission as $result)
                  <option  value="{{$result->id}}" 
                  @if(in_array($result->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$result->permission}}</option>
                 @endforeach
              @else
                  @foreach($result_permission as $result)
                  <option  value="{{$result->id}}" 
                  @if(in_array($result->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$result->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>

       <div class="field">
        <label>Remarks Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @if(!empty(old('permissions')) )
                 @foreach($remarks_permission as $remarks)
                  <option  value="{{$remarks->id}}" 
                  @if(in_array($remarks->id, old('permissions')))
                      selected="selected"
                  @endif
                  >{{$remarks->permission}}</option>
                 @endforeach
              @else
                  @foreach($remarks_permission as $remarks)
                  <option  value="{{$remarks->id}}" 
                  @if(in_array($remarks->id, $admin_permissions))
                      selected="selected"
                  @endif
                  >{{$remarks->permission}}</option>
                 @endforeach
              @endif
         </select>
      </div>
  	</div> 
  </div>

 
    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Create User</button>
  
  </form>
</section>
<div class="jtr"></div>
@endsection	