@extends('layouts.main')
@section('content')

<style>
.twelve {
  margin: 0 auto;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}

.form-group label {
    font-weight: bold;
}

.ui.form input[type="text"], .ui.form select {
    border: 1px solid #696969;
}
</style> 

  <section class="ui raised segment" style="max-width:500px; margin: 40px auto;">
    <form class="ui form" action="" method="post" enctype="multipart/form-data">
      <h2 class="ui dividing header">Upload School Result Signatures</h2>
            
      <input type="hidden" name="_token" value="{{csrf_token()}}">
      <input type="hidden" name="school_id" value="{{$school_id}}"> 

        @if(!empty($school->principal_sign)) 
         <div class="form-group">
            <label class="col-md-3 ">Current Principal Signature</label>
            <div class="col-md-5">
                  <img src="{{url_public($school->principal_sign)}}" style="max-height: 80px;">
            </div>
        </div>
        @endif

        <div class="form-group">
            <label class="col-md-3 ">Choose Principal Signature</label>
            <div class="col-md-5">
                    <input type="file" name="principal_sign" />                                      
            </div>
        </div>
        
        <div class="form-group">
            <label class="col-md-3 ">Principal Name</label>
            <div class="col-md-5">
                    <input type="text" name="principal_name" @if(!empty($school->principal_name)) value="{{$school->principal_name}}" @endif />                                      
            </div>
        </div>

<div style="display: none;">
        @if(!empty($school->counsellor_sign)) 
         <div class="form-group">
            <label class="col-md-3 ">Current Guardian Counsellor Signature</label>
            <div class="col-md-5">
                  <img src="{{url_public($school->counsellor_sign)}}" style="max-height: 80px;">
            </div>
        </div>
        @endif
        
        <div class="form-group">
            <label class="col-md-3 ">Choose Guardian Counsellor Signature</label>
            <div class="col-md-5">
                    <input type="file" name="counsellor_sign" />                                      
            </div>
        </div>
        
        <div class="form-group">
            <label class="col-md-3 ">Guardian Counsellor Name</label>
            <div class="col-md-5">
                    <input type="text" name="counsellor_name" @if(!empty($school->counsellor_name)) value="{{$school->counsellor_name}}" @endif />                                      
            </div>
        </div>  

</div>

        <div class="form-group">
            <label class="col-md-3 ">Next Session Resumption Date</label>
            <div class="col-md-5">
                    <div class="ui calendar field" id="example2">
                      <div class="ui input left icon">
                        <i class="calendar icon"></i>
                        <input type="text" name="next_session_date" @if(!empty($school->next_session_date)) value="{{$school->next_session_date}}" @endif />
                      </div>
                    </div>                                     
            </div>
        </div>

          <button class="ui fluid large orange submit button" type="submit">Save Update</button>
    </form>
  </section>
  <div class="jtr"></div>
@endsection