@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="{{route('admin.register.school.users')}}" method="post">
  <h2 class="ui dividing header">Create Admin</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    <label>Name</label>
        <input type="text" name="fullname" value="{{old('fullname')}}" placeholder="fullname">
  </div>

  <div class="field">
    <label>Username</label>
    <input type="text" name="username" value="{{old('username')}}" placeholder="Username">
  </div>
  <div class="field">
    <label>Email</label>
    <input type="email" name="email" value="{{old('email')}}" placeholder="Email Address">
  </div>
  <div class="field">
    <label>Phone</label>
    <input type="number" name="phone" value="{{old('phone')}}" placeholder="Phone Formart: 2348022222222">
  </div>
  <div class="field">
    <label>Password</label>
    <input type="password" name="password" placeholder="Password">
  </div>
  <div class="field">
    <label>Confirm Password</label>
    <input type="password" name="password_confirmation" placeholder="Confirm Password">
  </div>
  <div class="field">
    <div class="ui toggle checkbox">
		<input type="checkbox" name="status" {{old('status') == '1' ? 'checked="checked"' : 'no'}} value="1"><label>Account Status</label>
	</div>
  </div>

   <div class="field">
   <h4 class="ui dividing header">Permissions</h4>
    <div class="three fields">
      <div class="field">
        <label>Student Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >

             @foreach($student_permission as $student)
             	<option value="{{$student->id}}"  
				@if(!empty(old('permissions')) && in_array($student->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$student->permission}}</option>
             @endforeach
         </select>
      </div>
      <div class="field">
        <label>Techer Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($teacher_permission as $teacher)
             	<option value="{{$teacher->id}}"  
				@if(!empty(old('permissions')) && in_array($teacher->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$teacher->permission}}</option>
             @endforeach
         </select>
      </div>
      <div class="field">
        <label>Class Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($class_permission as $class)
             	<option value="{{$class->id}}"  
				@if(!empty(old('permissions')) && in_array($class->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$class->permission}}</option>
             @endforeach
         </select>
      </div>
  	</div>
  	<div class="three fields">
      <div class="field">
        <label>Classarm Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($classarm_permission as $classarm)
             	<option value="{{$classarm->id}}"  
				@if(!empty(old('permissions')) && in_array($classarm->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$classarm->permission}}</option>
             @endforeach
         </select>
      </div>
      <div class="field">
        <label>Assignment Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($assignment_permission as $assignment)
             	<option value="{{$assignment->id}}"  
				@if(!empty(old('permissions')) && in_array($assignment->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$assignment->permission}}</option>
             @endforeach
         </select>
      </div>
      <div class="field">
        <label>Subject Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($subject_permission as $subject)
             	<option value="{{$subject->id}}"  
				@if(!empty(old('permissions')) && in_array($subject->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$subject->permission}}</option>
             @endforeach
         </select>
      </div>
  	</div>
  	<div class="three fields">
      <div class="field">
        <label>User Registration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($user_permission as $user)
             	<option value="{{$user->id}}" 
				@if(!empty(old('permissions')) && in_array($user->id, old('permissions')))
                  selected="selected"
              @endif
             	>{{$user->permission}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <label>Result Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($result_permission as $result)
              <option value="{{$result->id}}" 
        @if(!empty(old('permissions')) && in_array($result->id, old('permissions')))
                  selected="selected"
              @endif
              >{{$result->permission}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <label>Remarks Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($remarks_permission as $remarks)
              <option value="{{$remarks->id}}" 
        @if(!empty(old('permissions')) && in_array($remarks->id, old('permissions')))
                  selected="selected"
              @endif
              >{{$remarks->permission}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <label>School House Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($school_house_permission as $school_house)
              <option value="{{$school_house->id}}" 
        @if(!empty(old('permissions')) && in_array($school_house->id, old('permissions')))
                  selected="selected"
              @endif
              >{{$school_house->permission}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <label>Debtor Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($debtor_permission as $debtor)
              <option value="{{$debtor->id}}" 
        @if(!empty(old('permissions')) && in_array($debtor->id, old('permissions')))
                  selected="selected"
              @endif
              >{{$debtor->permission}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <label>Transfer Configuration</label>
         <select multiple="" class="ui dropdown" name="permissions[]" >
             @foreach($transfer_permission as $transfer)
              <option value="{{$transfer->id}}" 
        @if(!empty(old('permissions')) && in_array($transfer->id, old('permissions')))
                  selected="selected"
              @endif
              >{{$transfer->permission}}</option>
             @endforeach
         </select>
      </div>

  	</div> 
  </div>

 
    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Create User</button>
  
  </form>
</section>
<div class="jtr"></div>
@endsection	