@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 1024px; margin: 40px auto;">
@include('partial.error')
    <h2 class="ui dividing header" style="color: orange;">{{$title}}</h2>
	<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Current School</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School to be Transfer</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student OSSIN</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Debtor Status</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Transfer Reason</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Actions on Transfer</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($transfers) > 0)
		  @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $transfers->perPage() @endphp
		  	@foreach($transfers as $transfer)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$transfer->formerSchool->name}}</td>
		      <td>{{$transfer->newSchool->name}}</td>
		      <td>{{trim($transfer->studentBeforeTransfer->surname.' '.$transfer->studentBeforeTransfer->firstname.' '.$transfer->studentBeforeTransfer->middlename)}}</td>
		      <td>{{$transfer->studentBeforeTransfer->regnum}}</td>
		      <td>{!!($transfer->debtor()->count()  > 0 && $transfer->status == 0) ? '<span style="color:red;">'.$transfer->debtor->issue.'</span>' : 'Student does not have any debt'!!}</td>
		      <td>
		      	{{$transfer->reason_for_transfer}}
		      </td>
		      <td class="std-view">
		      @if($transfer->former_school_status == 0)
			     <button class="ui labeled blue icon button" data-item="Are you sure want to Grant the Transfer?" data-messages="Are you sure you want to grant the transfer" data-href="{{route('admin.grant.transfer', ['id' => $transfer->id])}}">
					  <i class="edit icon"></i>
					  Grant Transfer
				</button>
			  @else
				  @if($transfer->new_school_status == 0 && ($transfer->student_new_school == auth('admin')->user()->school_id))
				    <button class="ui labeled blue icon button" data-item="Are you sure want to Accept the Transfer?" data-messages="Are you sure you want to accept the transfer" data-href="{{route('admin.accept.transfer', ['id' => $transfer->id])}}">
						  <i class="edit icon"></i>
						  Accept Transfer
					</button>
				  @else
				  	<a class="ui labeled orange icon button" href="{{route('admin.view.transfer', ['id' => $transfer->id])}}">
						  View Transfer Letter
					</a>
				  @endif
			  @endif
			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="8">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr>
			    <th colspan="8">
			      @include('pagination.default', ['paginator' => $transfers])
			    </th>
			</tr>
		  </tfoot>
		</table>

<div class="ui modal generate" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>
</section>
@endsection