@extends('layouts.main-datatable')
@section('content')

<style type="text/css">
.auto_scroll {
	height: 100px;
	max-height: 100px;
	padding:1% 1%; background:#FFF; border:2px solid #CCC; overflow-y:scroll;
}
</style>

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  Select Teacher for Transfer
		</h2>
		<table class="ui celled table" id="global_datatable">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Identification Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Subject Areas</div>
		    </th>
		    <th>
            
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($teachers) > 0)
		  	@php
		  	$sn = 1
		  	@endphp
		  	@foreach($teachers as $teacher)
		    <tr>
		    	<td>{{$sn}}</td>
		      <td>{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</td>
		      <td>{{$teacher->staff_no}}</td>
		      <td>
		      	<div class="ui middle aligned divided list auto_scroll">
		      	@foreach(getAssocSubject($teacher->id) as $t_s)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$t_s->subject_name}}</p>
				    </div>
				</div>
		      	@endforeach
		      	</div>
		      </td>
		      <td class="std-view">
		      	<a href="{{route('admin.view.transfer.new.request', ['id' => $teacher->id])}}">Process Transfer</a>		      
			  </td>
		    </tr>
		  	@php
		  	$sn++
		  	@endphp
		   @endforeach
		    @else
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>
	</section>
	
@endsection