@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 1024px; margin: 30px auto;">
	    <h2 class="ui horizontal divider header" style="color:#dc4900;">
		  {{$title}}
		</h2>
		@if(count($wallet) > 0)
    	<div class="ui statistics">
    	  <div class="statistic">
    	    <div class="value">
    	      ₦{{money_format('%i', $wallet->available_balance)}}
    	    </div>
    	    <div class="label">
    	      Available Balance
    	    </div>
    	  </div>
    	  <div class="statistic">
    	    <div class="value">
    	      ₦{{money_format('%i', $wallet->last_payment)}}
    	    </div>
    	    <div class="label">
    	      Last Payment
    	    </div>
    	  </div>
    	</div>
    	@else
    	<div class="ui statistics">
    	  <div class="statistic">
    	    <div class="value">
    	      ₦0.00
    	    </div>
    	    <div class="label">
    	      Available Balance
    	    </div>
    	  </div>
    	  <div class="statistic">
    	    <div class="value">
    	      ₦0.00
    	    </div>
    	    <div class="label">
    	      Last Payment
    	    </div>
    	  </div>
    	</div>
    	@endif
    	<br>
		<div class="search-bar printnone">
			<div class="ui stackable equal height stackable grid">
				<div class="seven wide column">
					<form method="get" action="" class="form form-horizontal global_form">
						<div class="second">
							<div class="fields">
								<div class="sixteen wide field">
									<div class="ui left action input fluid">
										<button class="ui orange labeled icon button">
											<i class="search icon"></i>
											Filter Transactions:
										</button>
										<select name="filter" class="ui search fluid dropdown">
											<option value="">Choose Time</option>
											<option @if(isset($_GET['filter']) && $_GET['filter'] == 'all') selected @endif value="all">All</option>
											<option @if(isset($_GET['filter']) && $_GET['filter'] == 'today') selected @endif value="today">Today</option>
											<option @if(isset($_GET['filter']) && $_GET['filter'] == 'yesterday') selected @endif value="yesterday">Yesterday</option>
											<option @if(isset($_GET['filter']) && $_GET['filter'] == 'this_week') selected @endif value="this_week">This Week</option>
											<option @if(isset($_GET['filter']) && $_GET['filter'] == 'this_month') selected @endif value="this_month">This Month</option>
										</select>
									</div>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<table class="ui celled table">
		  <thead>
		    <tr>
			  	<th>
			    	<div class="ui ribbon label">Payment Title</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">Payment Description</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">Paid Amount</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">Time</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  @if(count($transactions) > 0)
		  	@foreach($transactions as $transaction)
		    <tr>
		      <td>{{$transaction->title}}</td>
		      <td>{{$transaction->description}}</td>
		      <td>₦{{$transaction->amount}}</td>
		      <td>paid {{$transaction->created_at->diffForHumans()}}</td>
		   @endforeach
		    @else
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot class="printnone">
		      <tr>
		          <th colspan="5">
		              <button class="ui button orange" onclick="window.print()">Print Sheet</button>
		          </th>
		      </tr>
		    <tr><th colspan="5">
		      @include('pagination.default', ['paginator' => $transactions])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	
	<div class="jtr"></div>
@endsection