@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
    @include('partial.error')
    <form class="ui form" action="{{route('admin.school.timetable.view')}}" method="post">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <h2 class="ui dividing header">Create Class Time-Table</h2>
        <div class="two fields">
        
            <div class="field">
                <label>Class</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="class_id" value="{{old('class_id')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Class</div>
                <div class="menu">
                    @foreach($all_classes as $class)
                    <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                    @endforeach
                </div>
                </div>
            </div>
            
            <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Create Time-Table</button>
            </div>

        </div>
        
    </form>
    <br>
    <h2 class="ui horizontal divider header" style="color:#dc4900;">
        Or
    </h2>
    <br>

    <form class="ui form" action="{{route('admin.school.timetable.print')}}" method="post">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <h2 class="ui dividing header">Print Class Time-Table</h2>
        <div class="two fields">
        
            <div class="field">
                <label>Class</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="class_id" value="{{old('class_id')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Class</div>
                <div class="menu">
                    @foreach($all_classes as $class)
                    <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                    @endforeach
                </div>
                </div>
            </div>
            
            <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Create Time-Table</button>
            </div>

        </div>
        
    </form>
</section>
@endsection