@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
    @include('partial.error')
    <h2 class="ui horizontal divider header" style="color:#dc4900;">
        {{strtoupper($title)}}
    </h2>
    <table class="ui compact celled definition table">
        <thead class="full-width">
            <tr>
                <th></th>
                <th>Monday</th>
                <th>Tuesday</th>
                <th>Wednesday</th>
                <th>Thursday</th>
                <th>Friday</th>
            </tr>
        </thead>
        <tbody>
        <?php $timetablePeriods = $timetable->first()->period; ?>
        @if($timetablePeriods->count() > 0)
            @foreach($timetablePeriods as $timetablePeriod)
            <tr>
                <td class="collapsing">{{$timetablePeriod->time}}</td>
                <td>{{$timetablePeriod->monday}}</td>
                <td>{{$timetablePeriod->tuesday}}</td>
                <td>{{$timetablePeriod->wednesday}}</td>
                <td>{{$timetablePeriod->thursday}}</td>
                <td>{{$timetablePeriod->friday}}</td>
            </tr>
            @endforeach
        @endif
        </tbody>
    </table>
    <br>
    <button onclick="print()" class="print-none ui small fluid orange labeled icon button">
    <i class="print icon"></i> Print Table
    </butotn>
</section>
<style>
@media print{
    .print-none{
        display: none !important;
    }
}
</style>
@endsection