@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 98%; margin: 20px auto;">
    @include('partial.error')
    <h2 class="ui horizontal divider header" style="color:#dc4900;">
        <i class="calendar alternate icon"></i>
        {{$title}}
    </h2>
    <table class="ui compact celled definition table">
        <thead class="full-width">
            <tr>
                <th></th>
                <th>Monday</th>
                <th>Tuesday</th>
                <th>Wednesday</th>
                <th>Thursday</th>
                <th>Friday</th>
                <th></th>
                <th></th>
            </tr>
        </thead>
        <tbody>
        <?php $timetablePeriods = $timetable->first()->period; ?>
        @if($timetablePeriods->count() > 0)
            @foreach($timetablePeriods as $timetablePeriod)
            <form class="ui form" action="{{route('admin.school.edit.timetable')}}" method="post">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
                <input type="hidden" name="timetable_id" value="{{$timetable->first()->id}}">
                <input type="hidden" name="id" value="{{$timetablePeriod->id}}">
                <tr>
                    <td class="collapsing full-width">
                        <div class="ui input">
                            <input type="text" value="{{$timetablePeriod->time}}" placeholder="Time" required name="time">
                        </div>
                    </td>
                    <td>
                        <div class="field">
                            <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="monday" value="{{$timetablePeriod->monday}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Monday</div>
                                <div class="menu">
                                    <div class="item" data-value="Long Break">Long Break</div>
                                    <div class="item" data-value="Short Break">Short Break</div>
                                @foreach($subjects as $subject)
                                <div class="item" data-value="{{$subject->subject_name}} {{$subject->subject_code}}">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
                                @endforeach
                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="field">
                            <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="tuesday" value="{{$timetablePeriod->tuesday}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Tuesday</div>
                                <div class="menu">
                                    <div class="item" data-value="Long Break">Long Break</div>
                                    <div class="item" data-value="Short Break">Short Break</div>
                                @foreach($subjects as $subject)
                                <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
                                @endforeach
                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="field">
                            <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="wednesday" value="{{$timetablePeriod->wednesday}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Wednesday</div>
                                <div class="menu">
                                    <div class="item" data-value="Long Break">Long Break</div>
                                    <div class="item" data-value="Short Break">Short Break</div>
                                @foreach($subjects as $subject)
                                <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
                                @endforeach
                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="field">
                            <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="thursday" value="{{$timetablePeriod->thursday}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Thursday</div>
                                <div class="menu">
                                    <div class="item" data-value="Long Break">Long Break</div>
                                    <div class="item" data-value="Short Break">Short Break</div>
                                @foreach($subjects as $subject)
                                <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
                                @endforeach
                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="field">
                            <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="friday" value="{{$timetablePeriod->friday}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Friday</div>
                                <div class="menu">
                                    <div class="item" data-value="Long Break">Long Break</div>
                                    <div class="item" data-value="Short Break">Short Break</div>
                                @foreach($subjects as $subject)
                                <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
                                @endforeach
                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <button class="ui small fluid blue labeled icon button">
                        <i class="edit icon"></i> Edit Period
                        </butotn>
                    </td>
            </form>
                <form action="{{route('admin.school.edit.timetable.delete')}}" method="POST">
                    <td>
                        {{csrf_field()}}
                        <input type="hidden" name="id" value="{{$timetablePeriod->id}}">
                        <button class="ui small fluid red labeled icon button">
                        <i class="trash icon"></i> Delete Period
                        </butotn>
                    </td>
                </form>
            </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot class="full-width">
            <tr>
            <th></th>
            <th>Created at: {{$timetable->first()->created_at->diffForHumans()}}</th>
            <th>Updated at: {{$timetable->first()->updated_at->diffForHumans()}}</th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
			<form action="{{route('admin.school.delete.timetable')}}" method="POST">
			{{csrf_field()}}
			<input type="hidden" name="timetable_id" value="{{$timetable->first()->id}}">
            <th>
                <button class="ui small fluid red labeled icon button">
                <i class="trash icon"></i> Delete Table
                </butotn>
            </th>
			</form>
            </tr>
        </tfoot>
    </table>
</section>
@endsection